/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.models;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ListUtils;
import com.instabug.library.util.TimeUtils;
import com.instabug.survey.common.models.ActionEvent;
import com.instabug.survey.common.models.BaseLocalization;
import com.instabug.survey.common.models.Condition;
import com.instabug.survey.common.models.Frequency;
import com.instabug.survey.common.models.IUserInteraction;
import com.instabug.survey.common.models.SyncingStatus;
import com.instabug.survey.common.models.Target;
import com.instabug.survey.common.models.UserInteraction;
import com.instabug.survey.models.Question;
import com.instabug.survey.models.ThankYouItem;
import com.instabug.survey.utils.DateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Survey
implements Cacheable,
Serializable,
IUserInteraction {
    private static final String KEY_PUBLISHED = "published";
    private static final String KEY_PAUSED = "paused";
    private static final String KEY_ID = "id";
    private static final String KEY_TITLE = "title";
    private static final String KEY_TOKEN = "token";
    private static final String HAS_RESPOND = "has_respond";
    private static final String KEY_QUESTIONS = "questions";
    private static final String KEY_TARGET = "target";
    private static final String KEY_TARGET_AUDIENCE = "primitive_types";
    private static final String KEY_CUSTOM_ATTRIBUTES = "custom_attributes";
    private static final String KEY_USER_EVENTS = "user_events";
    private static final String KEY_CONDITIONS_OPERATOR = "operator";
    private static final String KEY_ANSWERED = "answered";
    private static final String KEY_DISMISSED_AT = "dismissed_at";
    private static final String KEY_IS_CANCELLED = "is_cancelled";
    private static final String KEY_SURVEY_EVENTS = "events";
    private static final String KEY_SURVEY_STATE = "survey_state";
    private static final String KEY_SHOULD_SHOW_AGAIN = "should_show_again";
    private static final String KEY_SESSION_COUNTER = "session_counter";
    private static final String KEY_WELCOME_SCREEN = "welcome_screen";
    private static final String KEY_TYPE = "type";
    private static final String KEY_THANKS_LIST = "thanks_list";
    private static final String KEY_SHOW_AT = "show_at";
    private static final String KEY_IS_GOOGLE_PLAY_APP_RATING = "app_rating";
    private static final String KEY_IS_DISMISSIBLE = "dismissible";
    private long id;
    private String title = "";
    private int type;
    @Nullable
    private String token;
    private ArrayList<Question> questions;
    private UserInteraction userInteraction;
    private boolean paused = false;
    private ArrayList<ThankYouItem> thankYouItems;
    private BaseLocalization localization;
    private boolean isGooglePlayAppRating = false;
    private boolean isDismissible = true;
    @Nullable
    private String sessionID;

    public Survey() {
        UserInteraction userInteraction;
        BaseLocalization baseLocalization;
        ArrayList arrayList;
        ArrayList arrayList2;
        Serializable serializable = arrayList2;
        arrayList2 = new ArrayList();
        v1.questions = serializable;
        serializable = arrayList;
        arrayList = new ArrayList();
        v1.thankYouItems = serializable;
        serializable = baseLocalization;
        baseLocalization = new BaseLocalization();
        v1.localization = serializable;
        serializable = userInteraction;
        userInteraction = new UserInteraction(0);
        v1.userInteraction = serializable;
    }

    public static List<Survey> getPausedSurveysFromJson(JSONObject jSONObject) {
        ArrayList<Survey> arrayList;
        jSONObject = jSONObject.getJSONArray(KEY_PAUSED);
        ArrayList<Survey> arrayList2 = arrayList;
        arrayList = new ArrayList<Survey>(jSONObject.length());
        for (int i = 0; i < jSONObject.length(); ++i) {
            Survey survey;
            Survey survey2 = survey;
            survey2();
            survey.setId(jSONObject.getLong(i));
            survey.setPaused(true);
            arrayList2.add(survey);
        }
        return arrayList2;
    }

    public static List<Survey> fromJson(@NonNull JSONObject jSONObject) {
        ArrayList<Survey> arrayList;
        jSONObject = jSONObject.getJSONArray(KEY_PUBLISHED);
        ArrayList<Survey> arrayList2 = arrayList;
        arrayList = new ArrayList<Survey>();
        for (int i = 0; i < jSONObject.length(); ++i) {
            JSONObject jSONObject2 = jSONObject.getJSONObject(i);
            Survey survey = new Survey();
            survey.fromJson(jSONObject2.toString());
            arrayList2.add(survey);
        }
        return arrayList2;
    }

    private boolean hasNPSSubmitted() {
        if (((Survey)((Object)iterator)).userInteraction.getTarget().getActionEvents() != null) {
            Iterator<ActionEvent> iterator = ((Survey)((Object)iterator)).userInteraction.getTarget().getActionEvents().iterator();
            while (iterator.hasNext()) {
                if (((ActionEvent)iterator.next()).getEventType() != ActionEvent.EventType.SUBMIT) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPromoter() {
        return this.getNPSAnswerValue() > 8;
    }

    private boolean isPassive() {
        return this.getNPSAnswerValue() > 6 && this.getNPSAnswerValue() <= 8;
    }

    private boolean isDetractor() {
        return this.getNPSAnswerValue() <= 6;
    }

    private int getNPSAnswerValue() {
        block5: {
            Object object;
            block4: {
                try {
                    object = (Question)ListUtils.safeGet(((Survey)object).questions, (int)0);
                    if (object != null) break block4;
                    return 0;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e((String)"IBG-Surveys", (String)("NPS score parsing failed du to: " + exception.getMessage()));
                    return 0;
                }
            }
            object = ((Question)object).getAnswer();
            if (object != null) break block5;
            return 0;
        }
        return Integer.parseInt((String)object);
    }

    @Nullable
    private String getNPSThankYouTitle() {
        Serializable serializable = this.getThankYouItems();
        if (((ArrayList)serializable).size() > 0) {
            ArrayList<ThankYouItem> arrayList = serializable;
            serializable = (ThankYouItem)ListUtils.safeGet(arrayList, (int)0);
            ThankYouItem thankYouItem = (ThankYouItem)ListUtils.safeGet(arrayList, (int)1);
            ThankYouItem thankYouItem2 = (ThankYouItem)ListUtils.safeGet(arrayList, (int)2);
            if (this.isPromoter() && serializable != null) {
                return ((ThankYouItem)serializable).getThankYouTitle();
            }
            if (this.isPassive() && thankYouItem != null) {
                return thankYouItem.getThankYouTitle();
            }
            if (this.isDetractor() && thankYouItem2 != null) {
                return thankYouItem2.getThankYouTitle();
            }
        }
        return null;
    }

    @Nullable
    private String getCustomThankYouTitle() {
        if (((ArrayList)(this = ((Survey)this).getThankYouItems())).size() > 0 && (this = (ThankYouItem)ListUtils.safeGet((List)((Object)this), (int)0)) != null) {
            return ((ThankYouItem)this).getThankYouTitle();
        }
        return null;
    }

    @Nullable
    private String getNPSThankYouMessage() {
        Serializable serializable = this.getThankYouItems();
        if (((ArrayList)serializable).size() > 0) {
            ArrayList<ThankYouItem> arrayList = serializable;
            serializable = (ThankYouItem)ListUtils.safeGet(arrayList, (int)0);
            ThankYouItem thankYouItem = (ThankYouItem)ListUtils.safeGet(arrayList, (int)1);
            ThankYouItem thankYouItem2 = (ThankYouItem)ListUtils.safeGet(arrayList, (int)2);
            if (this.isPromoter() && serializable != null) {
                return ((ThankYouItem)serializable).getThankYouMessage();
            }
            if (this.isPassive() && thankYouItem != null) {
                return thankYouItem.getThankYouMessage();
            }
            if (this.isDetractor() && thankYouItem2 != null) {
                return thankYouItem2.getThankYouMessage();
            }
        }
        return null;
    }

    @Nullable
    private String getCustomThankYouMessage() {
        if (((ArrayList)(this = ((Survey)this).getThankYouItems())).size() > 0 && (this = (ThankYouItem)ListUtils.safeGet((List)((Object)this), (int)0)) != null) {
            return ((ThankYouItem)this).getThankYouMessage();
        }
        return null;
    }

    private void setSessionCounter(int n) {
        this.userInteraction.setSessionCounter(n);
    }

    public Target getTarget() {
        return this.userInteraction.getTarget();
    }

    public void setTarget(Target target) {
        this.userInteraction.setTarget(target);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    @Override
    public long getSurveyId() {
        return this.id;
    }

    @Override
    public UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeAsString() {
        int n = this.type;
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    return "";
                }
                return "StoreRating";
            }
            return "NPS";
        }
        return "Custom";
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string2) {
        this.title = string2;
    }

    public void setSubmitted() {
        ActionEvent.EventType eventType;
        ActionEvent actionEvent;
        Survey survey = cacheable;
        survey.setCancelled(false);
        survey.setAnswered(true);
        if (survey.isNPSSurvey() && cacheable.isAnswered() && cacheable.hasNPSSubmitted() && cacheable.hasPositiveNpsAnswer()) {
            ActionEvent actionEvent2;
            actionEvent = actionEvent2;
            eventType = ActionEvent.EventType.RATE;
            long l = TimeUtils.currentTimeSeconds();
            int n = cacheable.getEventIndex();
            actionEvent2 = new ActionEvent(eventType, l, n);
        } else {
            ActionEvent actionEvent3;
            actionEvent = actionEvent3;
            eventType = ActionEvent.EventType.SUBMIT;
            long l = TimeUtils.currentTimeSeconds();
            int n = cacheable.getEventIndex();
            actionEvent3 = new ActionEvent(eventType, l, n);
            if (cacheable.isOptInSurvey()) {
                cacheable.userInteraction.setAttemptCount(0);
            }
        }
        Survey survey2 = cacheable;
        survey2.setSurveyState(SyncingStatus.READY_TO_SEND);
        Cacheable cacheable = survey2.userInteraction.getTarget();
        if (cacheable.getActionEvents() != null && cacheable.getActionEvents().size() > 0) {
            eventType = ActionEvent.EventType.SUBMIT;
            if (cacheable.getActionEvents().get(cacheable.getActionEvents().size() - 1).getEventType() == eventType && actionEvent.getEventType() == eventType) {
                return;
            }
        }
        if (cacheable.getActionEvents() != null) {
            cacheable.getActionEvents().add(actionEvent);
        }
    }

    public boolean isNPSSurvey() {
        return this.getType() == 1;
    }

    public boolean isStoreRatingSurvey() {
        return this.getType() == 2;
    }

    public ArrayList<Question> getQuestions() {
        return this.questions;
    }

    public void setQuestions(ArrayList<Question> arrayList) {
        this.questions = arrayList;
    }

    public ArrayList<Condition> getTargetAudiences() {
        return this.userInteraction.getTarget().getTargetAudiences();
    }

    public void setTargetAudiences(ArrayList<Condition> arrayList) {
        this.userInteraction.getTarget().setTargetAudiences(arrayList);
    }

    public ArrayList<Condition> getCustomAttributes() {
        return this.userInteraction.getTarget().getCustomAttributes();
    }

    public void setCustomAttributes(ArrayList<Condition> arrayList) {
        this.userInteraction.getTarget().setCustomAttributes(arrayList);
    }

    public ArrayList<Condition> getUserEvents() {
        return this.userInteraction.getTarget().getUserEvents();
    }

    public void setUserEvents(ArrayList<Condition> arrayList) {
        this.userInteraction.getTarget().setUserEvents(arrayList);
    }

    public ArrayList<ActionEvent> getSurveyEvents() {
        return this.userInteraction.getTarget().getActionEvents();
    }

    public void setSurveyEvents(ArrayList<ActionEvent> arrayList) {
        this.userInteraction.getTarget().setActionEvents(arrayList);
    }

    public String getConditionsOperator() {
        return this.userInteraction.getTarget().getConditionsOperator();
    }

    public void setConditionsOperator(String string2) {
        this.userInteraction.getTarget().setConditionsOperator(string2);
    }

    public boolean hasPositiveNpsAnswer() {
        return this.isNPSSurvey() && (this.isPromoter() || this.isPassive());
    }

    public int getEventIndex() {
        return this.userInteraction.getEventIndex();
    }

    public void setEventIndex(int n) {
        this.userInteraction.setEventIndex(n);
    }

    public boolean isOptInSurvey() {
        return this.getToken() != null && !String.valueOf(this.getToken()).equals("null");
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    public void setToken(@Nullable String string2) {
        this.token = string2;
    }

    public void setDismissed() {
        ActionEvent actionEvent;
        Survey survey = object;
        survey.setSurveyState(SyncingStatus.READY_TO_SEND);
        if (survey.isNPSSurvey() && object.hasPositiveNpsAnswer() && object.hasNPSSubmitted()) {
            return;
        }
        boolean bl = object.isOptInSurvey() || object.userInteraction.getDismissedAt() == 0L;
        Survey survey2 = object;
        survey2.setShouldShowAgain(bl);
        survey2.userInteraction.setDismissedAt(TimeUtils.currentTimeSeconds());
        survey2.setCancelled(true);
        if (survey2.userInteraction.getTarget().getActionEvents().size() > 0 && object.userInteraction.getTarget().getActionEvents().get(object.userInteraction.getTarget().getActionEvents().size() - 1).getEventType() == ActionEvent.EventType.DISMISS) {
            return;
        }
        Survey survey3 = object;
        ActionEvent actionEvent2 = actionEvent;
        Survey survey4 = object;
        Object object = ActionEvent.EventType.DISMISS;
        long l = survey4.userInteraction.getDismissedAt();
        int n = survey4.getEventIndex();
        actionEvent = new ActionEvent((ActionEvent.EventType)((Object)object), l, n);
        survey3.userInteraction.getTarget().getActionEvents().add(actionEvent2);
    }

    public void addShowEvent() {
        ActionEvent actionEvent;
        Survey survey = this;
        survey.userInteraction.setShownAt(TimeUtils.currentTimeSeconds());
        survey.userInteraction.incrementAttemptCount();
        ActionEvent actionEvent2 = actionEvent;
        Survey survey2 = this;
        long l = survey2.userInteraction.getShownAt();
        int n = survey2.userInteraction.incrementEventIndex();
        actionEvent = new ActionEvent(ActionEvent.EventType.SHOW, l, n);
        survey.userInteraction.getTarget().getActionEvents().add(actionEvent2);
    }

    public void addRateEvent() {
        ActionEvent actionEvent;
        Survey survey = object;
        ActionEvent actionEvent2 = actionEvent;
        Survey survey2 = object;
        Object object = ActionEvent.EventType.RATE;
        long l = TimeUtils.currentTimeSeconds();
        int n = survey2.getAttemptCount();
        actionEvent = new ActionEvent((ActionEvent.EventType)((Object)object), l, n);
        survey.userInteraction.getTarget().getActionEvents().add(actionEvent2);
    }

    public long getShownAt() {
        return this.userInteraction.getShownAt();
    }

    public void setShowAt(long l) {
        this.userInteraction.setShownAt(l);
    }

    public int getAttemptCount() {
        return this.userInteraction.getAttemptCount();
    }

    public void setAttemptCount(int n) {
        this.userInteraction.setAttemptCount(n);
    }

    public void setSessionCount(int n) {
        this.userInteraction.setSessionCounter(n);
    }

    @Nullable
    public String getThankYouTitle() {
        return this.isNPSSurvey() ? this.getNPSThankYouTitle() : this.getCustomThankYouTitle();
    }

    @Nullable
    public String getThankYouMessage() {
        return this.isNPSSurvey() ? this.getNPSThankYouMessage() : this.getCustomThankYouMessage();
    }

    public boolean isAppStoreRatingEnabled() {
        Serializable serializable = this.getThankYouItems();
        if (((ArrayList)serializable).size() > 0) {
            ArrayList<ThankYouItem> arrayList = serializable;
            serializable = (ThankYouItem)ListUtils.safeGet(arrayList, (int)0);
            ThankYouItem thankYouItem = (ThankYouItem)ListUtils.safeGet(arrayList, (int)1);
            if (this.isPromoter() && serializable != null) {
                return ((ThankYouItem)serializable).isAppStoreRatingEnabled();
            }
            if (this.isPassive() && thankYouItem != null) {
                return thankYouItem.isAppStoreRatingEnabled();
            }
        }
        return false;
    }

    @Nullable
    public String getRatingCTATitle() {
        Serializable serializable;
        if (this.isAppStoreRatingEnabled() && ((ArrayList)(serializable = this.getThankYouItems())).size() > 0) {
            ArrayList<ThankYouItem> arrayList = serializable;
            serializable = (ThankYouItem)ListUtils.safeGet(arrayList, (int)0);
            ThankYouItem thankYouItem = (ThankYouItem)ListUtils.safeGet(arrayList, (int)1);
            if (this.isPromoter() && serializable != null) {
                return ((ThankYouItem)serializable).getCallActionString();
            }
            if (this.isPassive() && thankYouItem != null) {
                return thankYouItem.getCallActionString();
            }
        }
        return null;
    }

    public void incrementSessionCount() {
        this.userInteraction.incrementSessionCount();
    }

    public boolean isCancelled() {
        return this.userInteraction.isCancelled();
    }

    public void setCancelled(boolean bl) {
        this.userInteraction.setCancelled(bl);
    }

    public void resetSessionsCounter() {
        this.userInteraction.setSessionCounter(0);
    }

    public void resetUserInteractions() {
        UserInteraction userInteraction;
        UserInteraction userInteraction2;
        Target target = this.userInteraction.getTarget();
        target.setActionEvents(new ArrayList<ActionEvent>());
        UserInteraction userInteraction3 = userInteraction2 = userInteraction;
        userInteraction3(0);
        this.userInteraction = userInteraction3;
        userInteraction.setTarget(target);
    }

    public void resetUserAnswers() {
        Iterator<Question> iterator = ((Survey)((Object)iterator)).questions.iterator();
        while (iterator.hasNext()) {
            ((Question)iterator.next()).resetAnswer();
        }
    }

    public long getRespondedAt() {
        if (this.isLastEventDismiss()) {
            return 0L;
        }
        if (this.userInteraction.getTarget().getActionEvents() != null && this.userInteraction.getTarget().getActionEvents().size() > 0) {
            for (ActionEvent actionEvent : this.userInteraction.getTarget().getActionEvents()) {
                if (actionEvent.getEventType() != ActionEvent.EventType.SUBMIT) continue;
                return actionEvent.getTimestamp();
            }
        }
        if (this.getQuestions() != null && this.getQuestions().size() > 0) {
            for (int i = this.getQuestions().size() - 1; i >= 0; --i) {
                if (this.getQuestions().get(i).getAnsweredAt() <= 0L) continue;
                return this.getQuestions().get(i).getAnsweredAt();
            }
        }
        return 0L;
    }

    public boolean isLastEventDismiss() {
        return this.userInteraction.getTarget().getActionEvents() != null && this.userInteraction.getTarget().getActionEvents().size() > 0 && this.userInteraction.getTarget().getActionEvents().get(this.userInteraction.getTarget().getActionEvents().size() - 1).getEventType() == ActionEvent.EventType.DISMISS;
    }

    public String toJson() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        long l = this.id;
        JSONObject jSONObject3 = jSONObject.put(KEY_ID, l).put(KEY_TYPE, this.type).put(KEY_IS_GOOGLE_PLAY_APP_RATING, this.isGooglePlayAppRating).put(KEY_TITLE, (Object)this.title);
        String string2 = KEY_TOKEN;
        String string3 = this.token;
        if (string3 == null) {
            string3 = "";
        }
        long l2 = this.userInteraction.getShownAt();
        JSONObject jSONObject4 = jSONObject3.put(string2, (Object)string3).put(KEY_QUESTIONS, (Object)Question.toJson(this.questions)).put(KEY_TARGET, (Object)Target.toJson(this.userInteraction.getTarget())).put(KEY_SURVEY_EVENTS, (Object)ActionEvent.toJson(this.userInteraction.getTarget().getActionEvents())).put(KEY_ANSWERED, this.userInteraction.isAnswered()).put(KEY_SHOW_AT, l2);
        l2 = this.getDismissedAt();
        jSONObject4.put(KEY_DISMISSED_AT, l2).put(KEY_IS_CANCELLED, this.userInteraction.isCancelled()).put(KEY_SURVEY_STATE, (Object)((Object)((Object)this.getSurveyState())).toString()).put(KEY_SHOULD_SHOW_AGAIN, this.shouldShowAgain()).put(KEY_THANKS_LIST, (Object)ThankYouItem.toJson(this.thankYouItems)).put(KEY_SESSION_COUNTER, this.getSessionCounter());
        this.localization.localizationToJson(jSONObject2);
        return jSONObject2.toString();
    }

    public boolean shouldShowAgain() {
        return this.userInteraction.isShouldShowAgain();
    }

    public long getDismissedAt() {
        return this.userInteraction.getDismissedAt();
    }

    public void setDismissedAt(long l) {
        this.userInteraction.setDismissedAt(l);
    }

    public SyncingStatus getSurveyState() {
        return this.userInteraction.getSurveyState();
    }

    public void setSurveyState(SyncingStatus syncingStatus) {
        this.userInteraction.setSurveyState(syncingStatus);
    }

    public int getSessionCounter() {
        return this.userInteraction.getSessionCounter();
    }

    public void fromJson(String string2) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject(string2);
        if (jSONObject2.has(KEY_ID)) {
            this.setId(jSONObject2.getLong(KEY_ID));
        }
        if (jSONObject2.has(KEY_TYPE)) {
            this.setType(jSONObject2.getInt(KEY_TYPE));
        }
        if (jSONObject2.has(KEY_TITLE)) {
            this.setTitle(jSONObject2.getString(KEY_TITLE));
        }
        if (jSONObject2.has(KEY_TOKEN) && jSONObject2.get(KEY_TOKEN) != JSONObject.NULL) {
            this.setToken(jSONObject2.getString(KEY_TOKEN));
        }
        if (jSONObject2.has(KEY_SURVEY_EVENTS)) {
            this.userInteraction.getTarget().setActionEvents(ActionEvent.fromJson(jSONObject2.getJSONArray(KEY_SURVEY_EVENTS)));
        }
        if (jSONObject2.has(KEY_QUESTIONS)) {
            this.setQuestions(Question.fromJson(jSONObject2.getJSONArray(KEY_QUESTIONS)));
        }
        if (jSONObject2.has(KEY_TARGET)) {
            string2 = jSONObject2.getJSONObject(KEY_TARGET);
            this.userInteraction.getTarget().fromJson(string2.toString().replace("\\", ""));
        }
        if (jSONObject2.has(KEY_ANSWERED)) {
            this.setAnswered(jSONObject2.getBoolean(KEY_ANSWERED));
        }
        if (jSONObject2.has(KEY_IS_CANCELLED)) {
            this.setCancelled(jSONObject2.getBoolean(KEY_IS_CANCELLED));
        }
        if (jSONObject2.has(KEY_SURVEY_STATE)) {
            this.setSurveyState(SyncingStatus.valueOf(jSONObject2.getString(KEY_SURVEY_STATE)));
        }
        if (jSONObject2.has(KEY_SHOULD_SHOW_AGAIN)) {
            this.setShouldShowAgain(jSONObject2.getBoolean(KEY_SHOULD_SHOW_AGAIN));
        }
        if (jSONObject2.has(KEY_SESSION_COUNTER)) {
            this.setSessionCounter(jSONObject2.getInt(KEY_SESSION_COUNTER));
        }
        if (jSONObject2.has(KEY_DISMISSED_AT)) {
            this.setDismissedAt(jSONObject2.getInt(KEY_DISMISSED_AT));
        }
        if (jSONObject2.has(KEY_SHOW_AT)) {
            this.setShowAt(jSONObject2.getInt(KEY_SHOW_AT));
        }
        if (jSONObject2.has(KEY_THANKS_LIST)) {
            this.setThankYouItems(ThankYouItem.fromJson(jSONObject2.getJSONArray(KEY_THANKS_LIST)));
        }
        if (jSONObject2.has(KEY_IS_DISMISSIBLE)) {
            this.setDismissible(jSONObject2.getBoolean(KEY_IS_DISMISSIBLE));
        }
        Survey survey = this;
        survey.localization.localizationFromJson(jSONObject2);
        survey.setGooglePlayAppRating(jSONObject2.optBoolean(KEY_IS_GOOGLE_PLAY_APP_RATING, false));
    }

    public long getId() {
        return this.id;
    }

    public Survey setId(long l) {
        this.id = l;
        return this;
    }

    public boolean isDismissible() {
        return this.isDismissible;
    }

    public void setDismissible(boolean bl) {
        this.isDismissible = bl;
    }

    public void setThankYouItems(ArrayList<ThankYouItem> arrayList) {
        this.thankYouItems = arrayList;
    }

    public ArrayList<ThankYouItem> getThankYouItems() {
        return this.thankYouItems;
    }

    public boolean isAnswered() {
        return this.userInteraction.isAnswered();
    }

    public void setAnswered(boolean bl) {
        this.userInteraction.setAnswered(bl);
    }

    public void setShouldShowAgain(boolean bl) {
        this.userInteraction.setShouldShowAgain(bl);
    }

    public BaseLocalization getLocalization() {
        return this.localization;
    }

    public void setLocalization(BaseLocalization baseLocalization) {
        this.localization = baseLocalization;
    }

    public void clearAnswers() {
        Iterator<Question> iterator = ((Survey)((Object)iterator)).questions.iterator();
        while (iterator.hasNext()) {
            ((Question)iterator.next()).setAnswer(null);
        }
    }

    public boolean isLastEventSubmit() {
        return this.userInteraction.getTarget().getActionEvents() != null && this.userInteraction.getTarget().getActionEvents().size() > 0 && this.userInteraction.getTarget().getActionEvents().get(this.userInteraction.getTarget().getActionEvents().size() - 1).getEventType() == ActionEvent.EventType.SUBMIT;
    }

    public boolean isGooglePlayAppRating() {
        return this.isGooglePlayAppRating;
    }

    public void setGooglePlayAppRating(boolean bl) {
        this.isGooglePlayAppRating = bl;
    }

    public int hashCode() {
        return String.valueOf(this.getId()).hashCode();
    }

    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Survey) {
            return ((Survey)object).getId() == this.getId();
        }
        return false;
    }

    @NonNull
    public String toString() {
        try {
            return this.toJson();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            if (jSONException.getMessage() != null) {
                InstabugSDKLogger.e((String)"Survey", (String)jSONException2.getMessage(), (Throwable)jSONException2);
            }
            return super.toString();
        }
    }

    public boolean shouldShow() {
        Survey survey = this;
        Target target = survey.userInteraction.getTarget();
        boolean bl = target.getFrequency().shouldShowEveryTime();
        boolean bl2 = this.userInteraction.isAlreadyShown();
        boolean bl3 = target.getFrequency().shouldShowOnce();
        boolean bl4 = DateUtils.getDifferenceInDaysFromSeconds(survey.getShownAt()) >= target.getFrequency().getShowingInterval();
        return bl || !bl2 || !bl3 && bl4 || this.shouldReshowAfterDismiss();
    }

    public boolean shouldReshowAfterDismiss() {
        Frequency frequency = this.getTarget().getFrequency();
        if (frequency.shouldNotReshowAfterDismiss()) {
            return false;
        }
        Survey survey = this;
        boolean bl = survey.isLastEventDismiss();
        boolean bl2 = DateUtils.getDifferenceInDaysFromSeconds(survey.getShownAt()) >= frequency.getDismissedReshowInterval();
        return bl && bl2;
    }

    @Nullable
    public Question getSecondaryNegativeQuestion() {
        if (this.isStoreRatingSurvey()) {
            if (this.isGooglePlayAppRating()) {
                return this.getQuestions().get(1);
            }
            return this.getQuestions().get(2);
        }
        return null;
    }

    @Nullable
    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(@Nullable String string2) {
        this.sessionID = string2;
    }
}

