/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.common;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.PresentationManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.SurveysManager;
import com.instabug.survey.announcements.models.Announcement;
import com.instabug.survey.announcements.ui.activity.AnnouncementActivity;
import com.instabug.survey.cache.SurveysCacheManager;
import com.instabug.survey.models.Survey;
import com.instabug.survey.ui.SurveyActivity;
import com.instabug.survey.utils.SurveysUtils;
import java.io.Serializable;

public class AutoShowingManager {
    private static AutoShowingManager instance;
    private boolean isAnnouncementShown;
    private boolean surveyShown;
    @Nullable
    Runnable showAnnnouncementRunnable;
    @Nullable
    Runnable showSurveyRunnable;

    public static synchronized AutoShowingManager getInstance() {
        if (instance == null) {
            instance = new AutoShowingManager();
        }
        return instance;
    }

    private boolean shouldShowAgain(long l) {
        Survey survey = SurveysCacheManager.getSurveyById(l);
        return survey != null && survey.shouldShow();
    }

    public void showAnnouncement(final Announcement announcement) {
        this.showAnnnouncementRunnable = new Runnable(){

            @Override
            public void run() {
                if (!announcement.shouldShow()) {
                    InstabugSDKLogger.w((String)"IBG-Surveys", (String)("this announcement " + announcement.getId() + " is answered and outdated"));
                    return;
                }
                Activity activity = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
                if (activity != null && SurveysManager.getInstance() != null) {
                    1 v0 = this;
                    SurveysManager.getInstance().unregisterSurveysTriggerEvents();
                    SurveysUtils.executeRunnableBeforeShowingSurvey();
                    v0.announcement.addShowEvent();
                    v0.AutoShowingManager.this.setAnnouncementShown(true);
                    Intent intent = new Intent((Context)activity, AnnouncementActivity.class);
                    intent.putExtra("announcement", (Serializable)announcement);
                    activity.startActivity(intent);
                }
            }
        };
        PresentationManager.getInstance().show(this.showAnnnouncementRunnable);
    }

    public void showSurvey(final @NonNull Survey survey) {
        this.showSurveyRunnable = new Runnable(){

            @Override
            public synchronized void run() {
                PoolProvider.postIOTaskWithCheck((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        2 var1_1 = this;
                        if (!var1_1.AutoShowingManager.this.shouldShowAgain(var1_1.survey.getId())) {
                            InstabugSDKLogger.w((String)AutoShowingManager.class.getSimpleName(), (String)("this survey " + survey.getId() + " is answered and outdated"));
                            return;
                        }
                        var1_1 = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
                        if (var1_1 != null && SurveysManager.getInstance() != null) {
                            SurveysManager.getInstance().unregisterSurveysTriggerEvents();
                            SurveysUtils.executeRunnableBeforeShowingSurvey();
                            if (survey.isOptInSurvey() && survey.getSurveyEvents() != null && survey.getSurveyEvents().size() > 0 && !survey.isLastEventDismiss()) {
                                survey.clearAnswers();
                            }
                            2 v0 = var1_1;
                            1 v1 = this;
                            v1.AutoShowingManager.this.setSurveyShown(true);
                            v1.survey.addShowEvent();
                            Intent intent = new Intent((Context)var1_1, SurveyActivity.class);
                            intent.putExtra("survey", (Serializable)survey);
                            v0.startActivity(intent);
                            v0.overridePendingTransition(0, 0);
                        }
                    }
                });
            }
        };
        PresentationManager.getInstance().show(this.showSurveyRunnable);
    }

    public void setSurveyShown(boolean bl) {
        this.surveyShown = bl;
    }

    public void setAnnouncementShown(boolean bl) {
        this.isAnnouncementShown = bl;
    }

    public void release() {
        AutoShowingManager autoShowingManager = this;
        autoShowingManager.showSurveyRunnable = null;
        autoShowingManager.showAnnnouncementRunnable = null;
    }
}

