/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.announcements.ui.fragment.whatsnew;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BackPressHandler;
import com.instabug.survey.R;
import com.instabug.survey.announcements.models.Announcement;
import com.instabug.survey.announcements.models.AnnouncementItem;
import com.instabug.survey.announcements.ui.activity.AnnouncementActivity;
import com.instabug.survey.announcements.ui.custom.DynamicRelativeLayout;
import com.instabug.survey.announcements.ui.fragment.AnnouncementItemFragment;
import com.instabug.survey.announcements.ui.fragment.whatsnew.WhatsNewContract$View;
import com.instabug.survey.announcements.ui.fragment.whatsnew.WhatsNewFeaturesAdapter;
import com.instabug.survey.announcements.ui.fragment.whatsnew.WhatsNewPresenter;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class WhatsNewFragment
extends AnnouncementItemFragment<WhatsNewPresenter>
implements View.OnTouchListener,
View.OnClickListener,
WhatsNewContract$View,
BackPressHandler {
    @VisibleForTesting
    @Nullable
    protected WhatsNewFeaturesAdapter whatsNewFeaturesAdapter;
    @VisibleForTesting
    @Nullable
    protected RecyclerView newFeaturesRecyclerView;
    @Nullable
    private Button submitButton;
    @Nullable
    private TextView title;
    @Nullable
    private WhatsNewPresenter presenter;
    @Nullable
    private AnnouncementActivity activityCallback;

    public static WhatsNewFragment newInstance(AnnouncementItem announcementItem) {
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putSerializable("announcement_item", (Serializable)announcementItem);
        WhatsNewFragment whatsNewFragment = new WhatsNewFragment();
        whatsNewFragment.setArguments(bundle2);
        return whatsNewFragment;
    }

    @Override
    public void onCreate(@Nullable Bundle bundle) {
        WhatsNewFragment whatsNewFragment = this;
        super.onCreate(bundle);
        whatsNewFragment.setRetainInstance(true);
    }

    @Override
    protected void initViews(View object, @Nullable Bundle bundle) {
        WhatsNewPresenter whatsNewPresenter;
        super.initViews((View)object, bundle);
        ((WhatsNewFragment)((Object)announcementItem)).title = (TextView)object.findViewById(R.id.instabug_announcement_title);
        ((WhatsNewFragment)((Object)announcementItem)).newFeaturesRecyclerView = (RecyclerView)object.findViewById(R.id.instabug_announcement_features_grid_view);
        ((WhatsNewFragment)((Object)announcementItem)).submitButton = (Button)object.findViewById(R.id.instabug_btn_submit);
        object = (RelativeLayout)object.findViewById(R.id.instabug_announcement_dialog_container);
        ((AnnouncementItemFragment)((Object)announcementItem)).container = object;
        if (object instanceof DynamicRelativeLayout) {
            object.setOnTouchListener((View.OnTouchListener)announcementItem);
            ((AnnouncementItemFragment)((Object)announcementItem)).container.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (WhatsNewFragment.this.container != null && WhatsNewFragment.this.submitButton != null && WhatsNewFragment.this.title != null) {
                        WhatsNewFragment whatsNewFragment = WhatsNewFragment.this;
                        if (whatsNewFragment.newFeaturesRecyclerView != null) {
                            if (((DynamicRelativeLayout)whatsNewFragment.container).isMaxHeightReached()) {
                                whatsNewFragment = (RelativeLayout.LayoutParams)WhatsNewFragment.this.submitButton.getLayoutParams();
                                whatsNewFragment.addRule(12);
                                if (Build.VERSION.SDK_INT >= 17) {
                                    whatsNewFragment.removeRule(3);
                                } else {
                                    whatsNewFragment.addRule(3, 0);
                                }
                                1 v0 = this;
                                v0.WhatsNewFragment.this.submitButton.setLayoutParams((ViewGroup.LayoutParams)whatsNewFragment);
                                whatsNewFragment = (RelativeLayout.LayoutParams)v0.WhatsNewFragment.this.title.getLayoutParams();
                                whatsNewFragment.addRule(10);
                                v0.WhatsNewFragment.this.title.setLayoutParams((ViewGroup.LayoutParams)whatsNewFragment);
                                whatsNewFragment = (RelativeLayout.LayoutParams)v0.WhatsNewFragment.this.newFeaturesRecyclerView.getLayoutParams();
                                whatsNewFragment.addRule(2, R.id.instabug_btn_submit);
                                v0.WhatsNewFragment.this.newFeaturesRecyclerView.setLayoutParams((ViewGroup.LayoutParams)whatsNewFragment);
                            }
                            if (Build.VERSION.SDK_INT >= 16) {
                                WhatsNewFragment.this.container.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                            } else {
                                WhatsNewFragment.this.container.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                            }
                            return;
                        }
                    }
                }
            });
        }
        if (announcementItem.getArguments() != null) {
            ((AnnouncementItemFragment)((Object)announcementItem)).announcementItem = (AnnouncementItem)announcementItem.getArguments().getSerializable("announcement_item");
        }
        object = whatsNewPresenter;
        whatsNewPresenter = new WhatsNewPresenter((WhatsNewContract$View)((Object)announcementItem));
        ((WhatsNewFragment)((Object)announcementItem)).presenter = object;
        AnnouncementItem announcementItem = ((AnnouncementItemFragment)((Object)announcementItem)).announcementItem;
        if (announcementItem != null) {
            ((WhatsNewPresenter)object).showWhatsNewAnnouncement(announcementItem);
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.activityCallback = (AnnouncementActivity)context;
            return;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(context.toString() + " must implement AnnouncementActivity");
        }
    }

    public void onDetach() {
        this.activityCallback = null;
        super.onDetach();
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        view.setFocusableInTouchMode(true);
    }

    protected int getLayout() {
        return R.layout.instabug_dialog_whats_new_announce;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        WhatsNewPresenter whatsNewPresenter = ((WhatsNewFragment)((Object)whatsNewPresenter)).presenter;
        if (whatsNewPresenter != null) {
            whatsNewPresenter.registerGestureHandler(view, motionEvent);
        }
        return true;
    }

    public void onClick(View view) {
        if (view.getId() == R.id.instabug_btn_submit) {
            this.submitAnnouncement();
        }
    }

    @Override
    public void dismissAnnouncement() {
        AnnouncementActivity announcementActivity = ((WhatsNewFragment)this).activityCallback;
        if (announcementActivity != null && (this = ((AnnouncementItemFragment)((Object)this)).announcement) != null) {
            announcementActivity.dismissAnnouncement((Announcement)this);
            return;
        }
    }

    public void submitAnnouncement() {
        Object object = this.announcement;
        if (object != null && ((Announcement)object).getAnnouncementItems() != null) {
            for (AnnouncementItem announcementItem : this.announcement.getAnnouncementItems()) {
                if (announcementItem.getOptions() == null) continue;
                AnnouncementItem announcementItem2 = announcementItem;
                announcementItem2.setAnswer(announcementItem2.getOptions().get(0));
            }
            object = this.activityCallback;
            if (object == null) {
                return;
            }
            ((AnnouncementActivity)object).submitAnnouncement(this.announcement);
            return;
        }
    }

    @Override
    public void showWhatsNewAnnouncement(AnnouncementItem object) {
        if (this.getActivity() == null) {
            return;
        }
        this.whatsNewFeaturesAdapter = new WhatsNewFeaturesAdapter((Activity)this.getActivity(), (AnnouncementItem)object);
        RecyclerView recyclerView = this.newFeaturesRecyclerView;
        if (recyclerView != null) {
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
            recyclerView.setAdapter((RecyclerView.Adapter)this.whatsNewFeaturesAdapter);
        }
        if ((recyclerView = this.title) != null) {
            String string2 = ((AnnouncementItem)object).getTitle() != null ? ((AnnouncementItem)object).getTitle() : "";
            recyclerView.setText((CharSequence)string2);
            this.title.setTextColor(InstabugCore.getPrimaryColor());
        }
        if (this.submitButton != null && ((AnnouncementItem)object).getOptions() != null && ((AnnouncementItem)object).getOptions().size() > 0) {
            WhatsNewFragment whatsNewFragment = this;
            object = ((AnnouncementItem)object).getOptions().get(0);
            whatsNewFragment.submitButton.setAllCaps(false);
            whatsNewFragment.submitButton.setText((CharSequence)object);
            whatsNewFragment.submitButton.setContentDescription((CharSequence)object);
            whatsNewFragment.submitButton.setBackgroundColor(InstabugCore.getPrimaryColor());
            whatsNewFragment.submitButton.setOnClickListener((View.OnClickListener)this);
        }
    }

    public boolean onBackPress() {
        return true;
    }
}

