/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.announcements.ui.activity;

import android.app.Activity;
import androidx.fragment.app.FragmentActivity;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.TimeUtils;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.announcements.cache.AnnouncementCacheManager;
import com.instabug.survey.announcements.models.Announcement;
import com.instabug.survey.announcements.network.AnnouncementSubmittingUtils;
import com.instabug.survey.announcements.network.InstabugAnnouncementSubmitterJob;
import com.instabug.survey.announcements.settings.PersistableSettings;
import com.instabug.survey.announcements.ui.activity.AnnouncementActivityContract$View;
import com.instabug.survey.common.LayoutUtils;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.ui.ViewType;
import org.json.JSONException;
import org.json.JSONObject;

public class AnnouncementPresenter
extends BasePresenter<AnnouncementActivityContract$View> {
    public AnnouncementPresenter(AnnouncementActivityContract$View announcementActivityContract$View) {
        super((BaseContract.View)announcementActivityContract$View);
    }

    private void handleOnFinishCallback(Announcement object, String string2) {
        Object object2 = SurveysSettings.getOnFinishCallback();
        if (object2 != null) {
            AnnouncementPresenter announcementPresenter = object2;
            Announcement announcement = object;
            String string3 = string2;
            object2 = Long.toString(((Announcement)object).getId());
            object = "SUBMITTED";
            string2 = AnnouncementSubmittingUtils.getAnnouncementAsResponse(announcement, string3);
            try {
                announcementPresenter.onFinish((String)object2, (String)object, (JSONObject)string2);
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Something went wrong during parsing Announcement object in onFinishCallback", (Throwable)jSONException);
            }
        }
    }

    private void finishAnnouncement(Announcement announcement) {
        PoolProvider.postIOTask(() -> {
            AnnouncementCacheManager.updateAnnouncement(announcement);
            if (PersistableSettings.getInstance() != null) {
                PersistableSettings.getInstance().setLastAnnouncementTime(TimeUtils.currentTimeMillis());
            }
            if ((this = (AnnouncementActivityContract$View)((BasePresenter)this).view.get()) != null && this.getViewContext() != null) {
                if (announcement.getType() == 100) {
                    AnnouncementCacheManager.deleteAnnouncementAssets();
                }
                InstabugAnnouncementSubmitterJob.getInstance().start();
                this.finishAnnouncement(false);
            }
        });
    }

    public void setLayoutHeightSecondary(boolean bl) {
        FragmentActivity fragmentActivity;
        AnnouncementActivityContract$View announcementActivityContract$View;
        announcementActivityContract$View = (AnnouncementActivityContract$View)((BasePresenter)announcementActivityContract$View).view.get();
        if (announcementActivityContract$View != null && announcementActivityContract$View.getViewContext() != null && (fragmentActivity = (FragmentActivity)announcementActivityContract$View.getViewContext()) != null) {
            int n = LayoutUtils.getLayoutHeight((Activity)fragmentActivity, ViewType.SECONDARY);
            if (bl) {
                announcementActivityContract$View.setFrameLayoutHeightWithAnimation(n);
            } else {
                announcementActivityContract$View.setFrameLayoutHeightTo(n);
            }
        }
    }

    public void submitAnnouncement(Announcement announcement) {
        if (announcement != null) {
            AnnouncementPresenter announcementPresenter = this;
            announcement.setSubmitted();
            announcementPresenter.handleOnFinishCallback(announcement, "SUBMITTED");
            announcementPresenter.finishAnnouncement(announcement);
        }
    }

    public void dismissAnnouncement(Announcement announcement) {
        if (announcement != null) {
            AnnouncementPresenter announcementPresenter = this;
            announcement.setDismissed();
            announcementPresenter.handleOnFinishCallback(announcement, "DISMISSED");
            announcementPresenter.finishAnnouncement(announcement);
        }
    }
}

