/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.announcements.network;

import com.instabug.library.core.InstabugCore;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.user.UserManagerWrapper;
import com.instabug.survey.announcements.models.Announcement;
import com.instabug.survey.announcements.models.AnnouncementItem;
import com.instabug.survey.common.models.ActionEvent;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AnnouncementSubmittingUtils {
    public static void addParamsToSubmittingAnnouncementRequest(Request.Builder builder, String string, Announcement announcement) {
        RequestParameter requestParameter;
        RequestParameter requestParameter2;
        Object object;
        if (announcement == null) {
            return;
        }
        if (announcement.getAnnouncementItems() != null && (object = AnnouncementSubmittingUtils.getResponsesFromAnnounceItem(announcement.getAnnouncementItems())).length() > 0) {
            RequestParameter requestParameter3;
            requestParameter2 = requestParameter3;
            requestParameter3 = new RequestParameter("responses", object);
            builder.addParameter(requestParameter2);
        }
        builder.addParameter(new RequestParameter("announcement_id", (Object)announcement.getId()));
        object = InstabugCore.getIdentifiedUsername();
        if (object != null) {
            RequestParameter requestParameter4;
            requestParameter2 = requestParameter4;
            requestParameter4 = new RequestParameter("name", object);
            builder.addParameter(requestParameter2);
        }
        Request.Builder builder2 = builder;
        builder2.addParameter(new RequestParameter("email", (Object)UserManagerWrapper.getUserEmail()));
        builder2.addParameter(new RequestParameter("responded_at", (Object)announcement.getRespondedAt()));
        builder2.addParameter(new RequestParameter("app_version", (Object)string));
        if (announcement.getTarget() != null && announcement.getTarget().getActionEvents() != null) {
            builder.addParameter(new RequestParameter("events", (Object)AnnouncementSubmittingUtils.getAnnouncementEvents(announcement.getTarget().getActionEvents())));
        }
        if (announcement.getLocalization() != null && announcement.getLocalization().getCurrentLocale() != null) {
            builder.addParameter(new RequestParameter("locale", (Object)announcement.getLocalization().getCurrentLocale()));
        }
        Request.Builder builder3 = builder;
        builder = requestParameter;
        requestParameter = new RequestParameter("push_token", (Object)InstabugCore.getPushNotificationToken());
        builder3.addParameter((RequestParameter)builder);
    }

    private static JSONArray getAnnouncementEvents(ArrayList<ActionEvent> jSONArray) {
        JSONArray jSONArray2;
        JSONArray jSONArray3 = jSONArray;
        jSONArray = jSONArray2;
        jSONArray2 = new JSONArray();
        for (ActionEvent actionEvent : jSONArray3) {
            JSONObject jSONObject;
            JSONObject jSONObject2 = jSONObject;
            jSONObject2();
            jSONObject2.put("event_type", (Object)actionEvent.getEventType());
            long l = actionEvent.getTimestamp();
            jSONObject2.put("timestamp", l);
            jSONObject.put("index", actionEvent.getIndex());
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray;
    }

    public static JSONArray getResponsesFromAnnounceItem(ArrayList<AnnouncementItem> jSONArray) {
        JSONArray jSONArray2;
        JSONArray jSONArray3 = jSONArray;
        jSONArray = jSONArray2;
        jSONArray2 = new JSONArray();
        for (AnnouncementItem announcementItem : jSONArray3) {
            JSONObject jSONObject;
            if (announcementItem.getAnswer() == null || announcementItem.getAnswer().equals("")) continue;
            JSONObject jSONObject2 = jSONObject;
            jSONObject2();
            jSONObject2.put("value", (Object)announcementItem.getAnswer());
            long l = announcementItem.getId();
            jSONObject.put("announcement_item_id", l);
            jSONArray.put((Object)jSONObject2);
        }
        return jSONArray;
    }

    public static JSONObject getAnnouncementAsResponse(Announcement announcement, String string) {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3 = jSONObject2 = jSONObject;
        jSONObject2();
        long l = announcement.getId();
        jSONObject2.put("id", l);
        jSONObject2.put("type", (Object)announcement.getTypeAsString());
        jSONObject3.put("title", (Object)announcement.getTitle());
        jSONObject3.put("is_announcement", true);
        jSONObject.put("responses", (Object)AnnouncementSubmittingUtils.getQuestionsAnswersAsJson(announcement, string));
        return jSONObject;
    }

    public static JSONArray getQuestionsAnswersAsJson(Announcement announcement, String string) {
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        if (announcement.getAnnouncementItems() != null) {
            for (AnnouncementItem announcementItem : announcement.getAnnouncementItems()) {
                JSONObject jSONObject;
                if (announcementItem.getAnswer() == null || announcementItem.getAnswer().equals("")) continue;
                JSONObject jSONObject2 = jSONObject;
                jSONObject2();
                long l = announcementItem.getId();
                jSONObject.put("question_id", l);
                String string2 = "question_title";
                String string3 = announcementItem.getTitle() != null ? announcementItem.getTitle() : "";
                jSONObject2.put(string2, (Object)string3);
                string2 = !announcementItem.getTypeAsString().equals("") ? announcementItem.getTypeAsString() : announcement.getTypeAsString();
                jSONObject2.put("question_type", (Object)string2);
                string2 = "response_timestamp";
                long l2 = string.equals("DISMISSED") ? announcement.getDismissedAt() : announcement.getRespondedAt();
                jSONObject2.put(string2, l2);
                jSONObject2.put("response_value", (Object)announcementItem.getAnswer());
                jSONArray2.put((Object)jSONObject2);
            }
        }
        return jSONArray2;
    }
}

