/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.announcements.models;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.TimeUtils;
import com.instabug.survey.announcements.models.AnnouncementItem;
import com.instabug.survey.common.models.ActionEvent;
import com.instabug.survey.common.models.BaseLocalization;
import com.instabug.survey.common.models.IUserInteraction;
import com.instabug.survey.common.models.SyncingStatus;
import com.instabug.survey.common.models.Target;
import com.instabug.survey.common.models.UserInteraction;
import com.instabug.survey.utils.DateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Announcement
implements Cacheable,
Serializable,
IUserInteraction {
    private long id;
    @Nullable
    private String title;
    private int type;
    @Nullable
    private ArrayList<AnnouncementItem> announcementItems;
    private boolean paused = false;
    private int assetsStatus = 0;
    private BaseLocalization localization;
    private UserInteraction userInteraction;

    public Announcement() {
        UserInteraction userInteraction;
        BaseLocalization baseLocalization;
        Serializable serializable = baseLocalization;
        baseLocalization = new BaseLocalization();
        v1.localization = serializable;
        serializable = userInteraction;
        userInteraction = new UserInteraction(1);
        v1.userInteraction = serializable;
    }

    public static List<Announcement> fromJson(JSONObject jSONObject) {
        ArrayList<Announcement> arrayList;
        jSONObject = jSONObject.getJSONArray("published");
        ArrayList<Announcement> arrayList2 = arrayList;
        arrayList = new ArrayList<Announcement>();
        for (int i = 0; i < jSONObject.length(); ++i) {
            JSONObject jSONObject2 = jSONObject.getJSONObject(i);
            Announcement announcement = new Announcement();
            announcement.fromJson(jSONObject2.toString());
            arrayList2.add(announcement);
        }
        return arrayList2;
    }

    private int incrementEventIndex() {
        return this.userInteraction.incrementEventIndex();
    }

    private void setSessionCounter(int n) {
        this.userInteraction.setSessionCounter(n);
    }

    public Target getTarget() {
        return this.userInteraction.getTarget();
    }

    public void setTarget(Target target) {
        this.userInteraction.setTarget(target);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String string) {
        this.title = string;
    }

    public void setSubmitted() {
        ActionEvent actionEvent;
        Announcement announcement = cacheable;
        announcement.setCancelled(false);
        announcement.setAnswered(true);
        announcement.setAlreadyShown(true);
        Cacheable cacheable = actionEvent;
        ActionEvent.EventType eventType = ActionEvent.EventType.SUBMIT;
        actionEvent = new ActionEvent(eventType, TimeUtils.currentTimeSeconds(), 1);
        announcement.setAnnouncementState(SyncingStatus.READY_TO_SEND);
        Target target = announcement.userInteraction.getTarget();
        if (target.getActionEvents().size() > 0 && target.getActionEvents().get(target.getActionEvents().size() - 1).getEventType() == eventType && cacheable.getEventType() == eventType) {
            return;
        }
        target.getActionEvents().add((ActionEvent)cacheable);
    }

    @Nullable
    public ArrayList<AnnouncementItem> getAnnouncementItems() {
        return this.announcementItems;
    }

    public void setAnnouncementItems(@Nullable ArrayList<AnnouncementItem> arrayList) {
        this.announcementItems = arrayList;
    }

    public ArrayList<ActionEvent> getAnnouncementEvents() {
        return this.userInteraction.getTarget().getActionEvents();
    }

    public int getAssetsStatus() {
        return this.assetsStatus;
    }

    public void setAssetsStatus(int n) {
        this.assetsStatus = n;
    }

    public String getConditionsOperator() {
        return this.userInteraction.getTarget().getConditionsOperator();
    }

    public void setConditionsOperator(String string) {
        this.userInteraction.getTarget().setConditionsOperator(string);
    }

    public int getEventIndex() {
        return this.userInteraction.getEventIndex();
    }

    public void setEventIndex(int n) {
        this.userInteraction.setEventIndex(n);
    }

    public void setDismissed() {
        ActionEvent actionEvent;
        Announcement announcement = object;
        announcement.setAnnouncementState(SyncingStatus.READY_TO_SEND);
        announcement.userInteraction.setDismissedAt(TimeUtils.currentTimeSeconds());
        announcement.setAnswered(true);
        announcement.setCancelled(true);
        announcement.setAlreadyShown(true);
        Cacheable cacheable = announcement.userInteraction.getTarget();
        if (cacheable.getActionEvents().size() > 0 && cacheable.getActionEvents().get(cacheable.getActionEvents().size() - 1).getEventType() == ActionEvent.EventType.DISMISS) {
            return;
        }
        Target target = cacheable;
        cacheable = actionEvent;
        Announcement announcement2 = object;
        Object object = ActionEvent.EventType.DISMISS;
        long l = announcement2.userInteraction.getDismissedAt();
        int n = announcement2.getEventIndex();
        actionEvent = new ActionEvent((ActionEvent.EventType)((Object)object), l, n);
        target.getActionEvents().add((ActionEvent)cacheable);
    }

    public void addShowEvent() {
        ActionEvent actionEvent;
        Announcement announcement = object;
        announcement.setShowAt(TimeUtils.currentTimeSeconds());
        ActionEvent actionEvent2 = actionEvent;
        Announcement announcement2 = object;
        Object object = ActionEvent.EventType.SHOW;
        long l = TimeUtils.currentTimeSeconds();
        int n = announcement2.incrementEventIndex();
        actionEvent = new ActionEvent((ActionEvent.EventType)((Object)object), l, n);
        announcement.userInteraction.getTarget().getActionEvents().add(actionEvent2);
    }

    public boolean isCancelled() {
        return this.userInteraction.isCancelled();
    }

    public void setCancelled(boolean bl) {
        this.userInteraction.setCancelled(bl);
    }

    public long getRespondedAt() {
        Target target = ((Announcement)((Object)target)).userInteraction.getTarget();
        if (target.getActionEvents() != null && target.getActionEvents().size() > 0) {
            for (ActionEvent actionEvent : target.getActionEvents()) {
                if (actionEvent.getEventType() != ActionEvent.EventType.SUBMIT && actionEvent.getEventType() != ActionEvent.EventType.DISMISS) continue;
                return actionEvent.getTimestamp();
            }
        }
        return 0L;
    }

    public String toJson() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        long l = this.id;
        JSONObject jSONObject3 = jSONObject2.put("id", l).put("type", this.type).put("title", (Object)this.title).put("announcement_items", (Object)AnnouncementItem.toJson(this.announcementItems)).put("target", (Object)Target.toJson(this.userInteraction.getTarget())).put("events", (Object)ActionEvent.toJson(this.userInteraction.getTarget().getActionEvents())).put("answered", this.userInteraction.isAnswered());
        l = this.getDismissedAt();
        jSONObject3.put("dismissed_at", l).put("is_cancelled", this.userInteraction.isCancelled()).put("announcement_state", (Object)((Object)((Object)this.getAnnouncementState())).toString()).put("should_show_again", this.shouldShow()).put("session_counter", this.getSessionCounter());
        this.localization.localizationToJson(jSONObject2);
        return jSONObject.toString();
    }

    public boolean shouldShow() {
        Announcement announcement = this;
        Target target = announcement.userInteraction.getTarget();
        boolean bl = target.getFrequency().shouldShowEveryTime();
        boolean bl2 = this.userInteraction.isAlreadyShown();
        boolean bl3 = target.getFrequency().shouldShowOnce();
        boolean bl4 = DateUtils.getDifferenceInDaysFromSeconds(announcement.getShownAt()) >= target.getFrequency().getShowingInterval();
        return bl || !bl2 || !bl3 && bl4;
    }

    public long getShownAt() {
        if (this.userInteraction.getShownAt() == 0L && this.userInteraction.getDismissedAt() != 0L) {
            Announcement announcement = this;
            announcement.setShowAt(announcement.userInteraction.getDismissedAt());
        }
        return this.userInteraction.getShownAt();
    }

    public void setShowAt(long l) {
        this.userInteraction.setShownAt(l);
    }

    public boolean isAlreadyShown() {
        return this.userInteraction.isAlreadyShown();
    }

    public void setAlreadyShown(boolean bl) {
        this.userInteraction.setAlreadyShown(bl);
    }

    public long getDismissedAt() {
        return this.userInteraction.getDismissedAt();
    }

    public void setDismissedAt(long l) {
        this.userInteraction.setDismissedAt(l);
    }

    public SyncingStatus getAnnouncementState() {
        return this.userInteraction.getSurveyState();
    }

    public void setAnnouncementState(SyncingStatus syncingStatus) {
        this.userInteraction.setSurveyState(syncingStatus);
    }

    public int getSessionCounter() {
        return this.userInteraction.getSessionCounter();
    }

    public void fromJson(String object) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject((String)object);
        if (jSONObject2.has("id")) {
            this.setId(jSONObject2.getLong("id"));
        }
        if (jSONObject2.has("type")) {
            this.setType(jSONObject2.getInt("type"));
        }
        if (jSONObject2.has("title")) {
            this.setTitle(jSONObject2.getString("title"));
        }
        if (jSONObject2.has("events")) {
            this.userInteraction.getTarget().setActionEvents(ActionEvent.fromJson(jSONObject2.getJSONArray("events")));
        }
        if (jSONObject2.has("announcement_items")) {
            this.setAnnouncementItems(AnnouncementItem.fromJson(jSONObject2.getJSONArray("announcement_items")));
        } else {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
            this.setAnnouncementItems((ArrayList<AnnouncementItem>)object);
        }
        if (jSONObject2.has("target")) {
            object = jSONObject2.getJSONObject("target");
            this.userInteraction.getTarget().fromJson(object.toString().replace("\\", ""));
        }
        if (jSONObject2.has("answered")) {
            this.setAnswered(jSONObject2.getBoolean("answered"));
        }
        if (jSONObject2.has("is_cancelled")) {
            this.setCancelled(jSONObject2.getBoolean("is_cancelled"));
        }
        if (jSONObject2.has("announcement_state")) {
            this.setAnnouncementState(SyncingStatus.valueOf(jSONObject2.getString("announcement_state")));
        }
        if (jSONObject2.has("session_counter")) {
            this.setSessionCounter(jSONObject2.getInt("session_counter"));
        }
        if (jSONObject2.has("dismissed_at")) {
            this.setDismissedAt(jSONObject2.getInt("dismissed_at"));
        }
        this.localization.localizationFromJson(jSONObject2);
    }

    public long getId() {
        return this.id;
    }

    public Announcement setId(long l) {
        this.id = l;
        return this;
    }

    public boolean isAnswered() {
        return this.userInteraction.isAnswered();
    }

    public void setAnswered(boolean bl) {
        this.userInteraction.setAnswered(bl);
    }

    public BaseLocalization getLocalization() {
        return this.localization;
    }

    @Override
    public long getSurveyId() {
        return this.id;
    }

    @Override
    public UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    public int hashCode() {
        return String.valueOf(this.getId()).hashCode();
    }

    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Announcement) {
            return ((Announcement)object).getId() == this.getId();
        }
        return false;
    }

    @NonNull
    public String toString() {
        try {
            return this.toJson();
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Error: " + jSONException.getMessage() + " while parsing announcement"), (Throwable)jSONException);
            return super.toString();
        }
    }

    public void resetUserInteractions() {
        UserInteraction userInteraction;
        UserInteraction userInteraction2;
        Target target = this.userInteraction.getTarget();
        target.setActionEvents(new ArrayList<ActionEvent>());
        UserInteraction userInteraction3 = userInteraction2 = userInteraction;
        userInteraction3(0);
        this.userInteraction = userInteraction3;
        userInteraction.setTarget(target);
    }

    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    public String getTypeAsString() {
        int n = this.type;
        if (n != 100) {
            if (n != 101) {
                return "";
            }
            return "UpdateMessage";
        }
        return "WhatsNew";
    }
}

