/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.announcements.cache;

import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.announcements.cache.AnnouncementAssetsDBHelper;
import com.instabug.survey.announcements.cache.AnnouncementsDBHelper;
import com.instabug.survey.announcements.models.Announcement;
import java.util.Iterator;
import java.util.List;

@WorkerThread
public abstract class AnnouncementCacheManager {
    public static void addAnnouncement(Announcement announcement) {
        AnnouncementsDBHelper.insert(announcement);
    }

    public static void insertOrUpdatePausedOrLocale(final Announcement announcement, final boolean bl, final boolean bl2) {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                1 v0 = this;
                boolean bl3 = v0.bl;
                AnnouncementsDBHelper.insertOrUpdatePausedOrLocale(announcement, bl3, v0.bl2);
            }
        });
    }

    public static List<Announcement> getAnnouncementsByType(int n) {
        return AnnouncementsDBHelper.retrieveByType(n);
    }

    public static List<Announcement> getReadyToBeSend() {
        return AnnouncementsDBHelper.retrieveReadyToBeSend();
    }

    public static List<Announcement> getAllAnnouncement() {
        return AnnouncementsDBHelper.retrieve();
    }

    public static void updateAnnouncement(Announcement announcement) {
        AnnouncementsDBHelper.update(announcement);
    }

    public static void deleteAnnouncement(String string) {
        AnnouncementsDBHelper.delete(string);
    }

    public static boolean isAnnouncementExist(long l) {
        return AnnouncementsDBHelper.isExisting(l);
    }

    @Nullable
    public static Announcement getAnnouncement(long l) {
        return AnnouncementsDBHelper.retrieveById(l);
    }

    public static long insertAnnouncementAsset(long l, long l2, String string) {
        return AnnouncementAssetsDBHelper.insert(l, l2, string);
    }

    @Nullable
    public static String getAnnouncementAsset(long l, long l2) {
        return AnnouncementAssetsDBHelper.retrieveAssetsPathOf(l, l2);
    }

    public static void deleteAnnouncementAssets() {
        AnnouncementAssetsDBHelper.delete();
    }

    public static void resetAnnouncementUserInteraction(List<Announcement> list) {
        Iterator<Announcement> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next().resetUserInteractions();
        }
        AnnouncementsDBHelper.updateBulk(list);
    }

    public static void updateBulk(List<Announcement> list) {
        AnnouncementsDBHelper.updateBulk(list);
    }

    public static void updateAssetStatus(long l, int n) {
        AnnouncementsDBHelper.updateAssetStatus(l, n);
    }
}

