/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.library.Feature;
import com.instabug.library.OnUsageExceededReady;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.Survey;
import com.instabug.survey.SurveysManager;
import com.instabug.survey.callbacks.OnDismissCallback;
import com.instabug.survey.callbacks.OnFinishCallback;
import com.instabug.survey.callbacks.OnShowCallback;
import com.instabug.survey.di.ServiceLocator;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.utils.SurveysUtils;
import java.util.List;

public class Surveys {
    @WorkerThread
    public static boolean showSurveyIfAvailable() {
        ReturnableRunnable<Boolean> returnableRunnable;
        Object object = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<Boolean>(){

            @Nullable
            public Boolean run() {
                InstabugSDKLogger.d((String)"IBG-Surveys", (String)"showSurveyIfAvailable");
                return SurveysManager.getInstance() != null && SurveysManager.getInstance().showValidSurvey();
            }
        };
        Boolean bl = Boolean.FALSE;
        return (object = (Boolean)APIChecker.checkAndGet((String)"Surveys.showSurveyIfAvailable", (ReturnableRunnable)object, (Object)bl)) != null && ((Boolean)object).booleanValue();
    }

    @WorkerThread
    @Nullable
    public static List<Survey> getAvailableSurveys() {
        ReturnableRunnable<List<Survey>> returnableRunnable;
        ReturnableRunnable<List<Survey>> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<List<Survey>>(){

            @Nullable
            public List<Survey> run() {
                InstabugSDKLogger.d((String)"IBG-Surveys", (String)"getAvailableSurveys");
                if (SurveysManager.getInstance() != null && SurveysUtils.isSurveysFeatureEnabled() && ServiceLocator.getConfigurationsProvider().isSurveysAvailableAndUsageNotExceeded()) {
                    return SurveysManager.getInstance().getAvailableSurveys();
                }
                return null;
            }
        };
        return (List)APIChecker.checkAndGet((String)"Surveys.getAvailableSurveys", (ReturnableRunnable)returnableRunnable2, null);
    }

    public static void setAutoShowingEnabled(final boolean bl) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                InstabugSDKLogger.d((String)"IBG-Surveys", (String)("setAutoShowingEnabled:" + bl));
                SurveysSettings.setSurveysAutoShowing(bl);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"Surveys.setAutoShowingEnabled", (VoidRunnable)voidRunnable2);
    }

    public static void setOnShowCallback(final OnShowCallback onShowCallback) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                SurveysSettings.setOnShowCallback(onShowCallback);
            }
        };
        APIChecker.checkAndRunInExecutorThenPostOnMain((String)"Surveys.setOnShowCallback", (VoidRunnable)voidRunnable2);
    }

    public static void setOnDismissCallback(final OnDismissCallback onDismissCallback) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                SurveysSettings.setOnDismissCallback(onDismissCallback);
            }
        };
        APIChecker.checkAndRunInExecutorThenPostOnMain((String)"Surveys.setOnDismissCallback", (VoidRunnable)voidRunnable2);
    }

    @WorkerThread
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public static boolean showSurvey(@NonNull String object) {
        ReturnableRunnable<Boolean> returnableRunnable;
        ReturnableRunnable<Boolean> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<Boolean>((String)object){
            final /* synthetic */ String val$token;
            {
                this.val$token = string;
            }

            public Boolean run() {
                String string = this.val$token;
                if (string != null && !string.equals("null")) {
                    return SurveysManager.getInstance() != null && SurveysManager.getInstance().showSurvey(this.val$token);
                }
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Survey token was null");
                return Boolean.FALSE;
            }
        };
        object = Boolean.FALSE;
        return (Boolean)APIChecker.checkAndGet((String)"Surveys.showSurvey", (ReturnableRunnable)returnableRunnable2, (Object)object);
    }

    private static void showSurveyCP(@NonNull String string) {
        APIChecker.checkAndRunInExecutor((String)"Surveys.showSurveyCP", () -> Surveys.showSurvey(string));
    }

    @WorkerThread
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public static boolean hasRespondToSurvey(@NonNull String object) {
        ReturnableRunnable<Boolean> returnableRunnable;
        ReturnableRunnable<Boolean> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<Boolean>((String)object){
            final /* synthetic */ String val$token;
            {
                this.val$token = string;
            }

            public Boolean run() {
                String string = this.val$token;
                if (string != null && !string.equals("null")) {
                    return SurveysManager.getInstance() != null && SurveysManager.getInstance().hasRespondToSurvey(this.val$token);
                }
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Survey token was null");
                return Boolean.FALSE;
            }
        };
        object = Boolean.FALSE;
        return (Boolean)APIChecker.checkAndGet((String)"Surveys.hasRespondToSurvey", (ReturnableRunnable)returnableRunnable2, (Object)object);
    }

    public static void setShouldShowWelcomeScreen(final boolean bl) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                SurveysSettings.setShouldShowSurveysWelcomeScreen(bl);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"Surveys.setShouldShowWelcomeScreen", (VoidRunnable)voidRunnable2);
    }

    public static void setState(final @NonNull Feature.State state) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                9 v0 = this;
                InstabugCore.setFeatureState((String)"SURVEYS", (Feature.State)v0.state);
                InstabugCore.setFeatureState((String)"ANNOUNCEMENTS", (Feature.State)v0.state);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"Surveys.setState", (VoidRunnable)voidRunnable2);
    }

    private static void enableCustomization() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                SurveysSettings.enableCustomization();
            }
        };
        APIChecker.checkAndRunInExecutor((String)"Surveys.enableCustomization", (VoidRunnable)voidRunnable2);
    }

    public static void setIsAppStoreRatingEnabled(final boolean bl) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                SurveysSettings.setIsAppStoreRatingEnabled(bl);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"Surveys.setIsAppStoreRatingEnabled", (VoidRunnable)voidRunnable2);
    }

    public static void setOnFinishCallback(final OnFinishCallback onFinishCallback) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                SurveysSettings.setOnFinishCallback(onFinishCallback);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"Surveys.setOnFinishCallback", (VoidRunnable)voidRunnable2);
    }

    public static void getUsageExceeded(@NonNull OnUsageExceededReady onUsageExceededReady) {
        block2: {
            try {
                APIChecker.checkAndRunOrThrow((String)"Surveys.getUsageExceeded", () -> PoolProvider.postMainThreadTask(() -> Surveys.lambda$getUsageExceeded$1(onUsageExceededReady, ServiceLocator.getConfigurationsProvider().isSurveysUsageExceeded())));
            }
            catch (Exception exception) {
                if (onUsageExceededReady == null) break block2;
                onUsageExceededReady.onReady(false);
            }
        }
    }

    private static /* synthetic */ void lambda$getUsageExceeded$1(OnUsageExceededReady onUsageExceededReady, boolean bl) {
        if (onUsageExceededReady != null) {
            onUsageExceededReady.onReady(bl);
        }
    }
}

