/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventSubscriber;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGCompositeDisposable;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.OnDiskCache;
import com.instabug.library.tokenmapping.MappedTokenChangedEventBus;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.SurveysManager;
import com.instabug.survey.announcements.AnnouncementManager;
import com.instabug.survey.announcements.cache.AnnouncementCacheManager;
import com.instabug.survey.announcements.cache.AnnouncementsDBHelper;
import com.instabug.survey.announcements.network.InstabugAnnouncementSubmitterJob;
import com.instabug.survey.announcements.settings.AnnouncementsSettings;
import com.instabug.survey.cache.SurveysCacheManager;
import com.instabug.survey.configuration.SurveysConfigurationsProvider;
import com.instabug.survey.di.ServiceLocator;
import com.instabug.survey.models.CountryInfo;
import com.instabug.survey.models.Survey;
import com.instabug.survey.network.service.InstabugSurveysSubmitterJob;
import com.instabug.survey.settings.PerSessionSettings;
import com.instabug.survey.settings.PersistableSettings;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.utils.PlayStoreUtils;
import com.instabug.survey.utils.SurveysUtils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Locale;

public class SurveyPlugin
extends Plugin {
    @Nullable
    IBGCompositeDisposable disposables;
    @Nullable
    private AnnouncementManager announcementManager;
    private final SurveysConfigurationsProvider configurationsProvider = ServiceLocator.getConfigurationsProvider();
    @VisibleForTesting
    @Nullable
    IBGDisposable mappedTokenChangeDisposable;

    private void initAnnouncementSettings(Context context) {
        this.announcementManager = AnnouncementManager.getInstance(context);
        com.instabug.survey.announcements.settings.PersistableSettings.init(context);
    }

    @NonNull
    private IBGDisposable subscribeToSDKCoreEvents() {
        return IBGCoreEventSubscriber.subscribe(this::handleCoreEvents);
    }

    private void handleCoreEvents(IBGSdkCoreEvent iBGSdkCoreEvent) {
        if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.NetworkActivated) {
            this.handleNetworkActivated();
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.User) {
            this.handleUserEvent((IBGSdkCoreEvent.User)iBGSdkCoreEvent);
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.CacheDumped) {
            this.handleCacheDumped();
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.FeaturesFetched) {
            this.handleFeaturesFetched((IBGSdkCoreEvent.FeaturesFetched)iBGSdkCoreEvent);
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.Features.Fetched && SurveysUtils.isSurveysFeatureEnabled()) {
            this.startFetchingRequests();
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.CodePushVersionChanged) {
            this.handleAppVersionChanged();
        }
    }

    private void handleFeaturesFetched(IBGSdkCoreEvent.FeaturesFetched featuresFetched) {
        ServiceLocator.getConfigurationHandler().handleConfiguration(featuresFetched.getResponse());
    }

    private void handleCacheDumped() {
        if (SurveysUtils.isSurveysFeatureEnabled()) {
            PoolProvider.postIOTask(AnnouncementsDBHelper::resetAssetsStatus);
        }
    }

    private void handleUserEvent(IBGSdkCoreEvent.User user) {
        if (user instanceof IBGSdkCoreEvent.User.LoggedIn) {
            this.handleUserLogIn();
        } else {
            this.handleUserLogOut();
        }
    }

    private void handleUserLogOut() {
        SurveyPlugin.clearUserActivities();
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            if (SurveysManager.getInstance() != null) {
                SurveysManager.getInstance().notifyLogout();
                AnnouncementManager.getInstance((Context)this.contextWeakReference.get()).notifyLogout();
            }
            return;
        }
    }

    private void handleUserLogIn() {
        if (SurveysManager.getInstance() == null) {
            return;
        }
        SurveysManager.getInstance().notifyUserLoggedIn();
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            AnnouncementManager.getInstance((Context)this.contextWeakReference.get()).notifyUserLoggedIn();
            return;
        }
    }

    private void handleNetworkActivated() {
        SurveyPlugin surveyPlugin = this;
        surveyPlugin.startSubmittingPendingSurveys();
        surveyPlugin.startSubmittingPendingAnnouncements();
    }

    private void handleAppVersionChanged() {
        SurveyPlugin surveyPlugin = object;
        Object object = null;
        WeakReference weakReference = surveyPlugin.contextWeakReference;
        if (weakReference != null) {
            object = (Context)weakReference.get();
        }
        if (object != null) {
            AnnouncementManager.getInstance((Context)object).notifyAppVersionChanged();
        }
        if ((object = SurveysManager.getInstance()) != null) {
            ((SurveysManager)object).notifyAppVersionChanged();
        }
    }

    private IBGCompositeDisposable getOrCreateDisposables() {
        IBGCompositeDisposable iBGCompositeDisposable = this.disposables;
        if (iBGCompositeDisposable == null) {
            IBGCompositeDisposable iBGCompositeDisposable2;
            iBGCompositeDisposable = iBGCompositeDisposable2;
            iBGCompositeDisposable2 = new IBGCompositeDisposable();
            this.disposables = iBGCompositeDisposable;
        }
        return iBGCompositeDisposable;
    }

    private void subscribeOnMappedTokenChangedEvent() {
        if (this.mappedTokenChangeDisposable == null) {
            this.mappedTokenChangeDisposable = MappedTokenChangedEventBus.INSTANCE.subscribe(object -> {
                object = this.contextWeakReference;
                if (object != null && ((Reference)object).get() != null && (object = AnnouncementManager.getInstance((Context)this.contextWeakReference.get())) != null) {
                    ((AnnouncementManager)object).setHasTokenChanged(true);
                }
                if ((object = SurveysManager.getInstance()) != null) {
                    ((SurveysManager)object).setHasTokenChanged(true);
                }
                SurveyPlugin surveyPlugin = this;
                AnnouncementsSettings.getInstance().setLastFetchedAt(0L);
                surveyPlugin.fetchSurveysImmediately(surveyPlugin.getLocaleResolved());
                surveyPlugin.startFetchingAnnouncements(surveyPlugin.getLocaleResolved());
                surveyPlugin.resolveCountryInfo(new CountryInfo(), true);
            });
        }
    }

    private void startFetchingRequests() {
        PoolProvider.postIOTask(() -> {
            SurveyPlugin surveyPlugin = this;
            surveyPlugin.startFetchingSurveys(surveyPlugin.getLocaleResolved());
            surveyPlugin.startFetchingAnnouncements(surveyPlugin.getLocaleResolved());
            surveyPlugin.resolveCountryInfo(new CountryInfo(), false);
        });
    }

    private void startSubmittingPendingAnnouncements() {
        if (InstabugCore.getFeatureState((String)"ANNOUNCEMENTS") == Feature.State.ENABLED && ((SurveyPlugin)((Object)weakReference)).configurationsProvider.isAnnouncementsAvailable()) {
            WeakReference weakReference = ((Plugin)weakReference).contextWeakReference;
            if (weakReference != null) {
                if ((Context)weakReference.get() != null) {
                    PoolProvider.postIOTask(() -> {
                        if (!AnnouncementCacheManager.getReadyToBeSend().isEmpty()) {
                            InstabugAnnouncementSubmitterJob.getInstance().start();
                        }
                    });
                } else {
                    InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Couldn't submit announcements due to null context");
                }
            } else {
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Couldn't submit announcements due to null context");
            }
        }
    }

    private void unSubscribeOnSDKEvents() {
        SurveyPlugin surveyPlugin = surveyPlugin.disposables;
        if (surveyPlugin != null) {
            surveyPlugin.dispose();
        }
    }

    private void unsubscribeFromMappedTokenChangedEvent() {
        IBGDisposable iBGDisposable = this.mappedTokenChangeDisposable;
        if (iBGDisposable != null) {
            iBGDisposable.dispose();
            this.mappedTokenChangeDisposable = null;
        }
    }

    private void startSubmittingPendingSurveys() {
        if (InstabugCore.getFeatureState((String)"SURVEYS") == Feature.State.ENABLED && this.configurationsProvider.isSurveysAvailable()) {
            WeakReference weakReference = this.contextWeakReference;
            if (weakReference != null) {
                if ((Context)weakReference.get() != null) {
                    PoolProvider.postIOTask(() -> {
                        SurveyPlugin surveyPlugin = list;
                        List<Survey> list = SurveysCacheManager.getReadyToSendSurveys();
                        if (surveyPlugin.contextWeakReference != null && !list.isEmpty()) {
                            InstabugSurveysSubmitterJob.getInstance().start();
                        }
                    });
                } else {
                    InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Couldn't submit surveys due to null context");
                }
            } else {
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Couldn't submit surveys due to null context");
            }
        }
    }

    private static void clearUserActivities() {
        if (PersistableSettings.getInstance() == null) {
            return;
        }
        PersistableSettings.getInstance().setLastSurveyTime(0L);
        PersistableSettings.getInstance().setCountryCodeLastFetch(0L);
    }

    private void removeOldSurveys() {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!SurveysSettings.hasBeenMigrated() && SurveyPlugin.this.contextWeakReference != null && SurveyPlugin.this.contextWeakReference.get() != null) {
                    new OnDiskCache((Context)SurveyPlugin.this.contextWeakReference.get(), "surveys_disk_cache", "/surveys.cache", Survey.class).delete();
                    SurveysSettings.markSurveysFilesMigrated();
                }
            }
        });
    }

    private void checkAppStatus() {
        Object object = ((Plugin)object).contextWeakReference;
        if (object != null && (object = (Context)((Reference)object).get()) != null) {
            PlayStoreUtils.isLiveApp((Context)object);
        }
    }

    private String getLocaleResolved() {
        if (this.getAppContext() == null) {
            return "default";
        }
        return LocaleUtils.getCurrentLocaleResolved((Context)this.getAppContext());
    }

    public void init(Context context) {
        super.init(context);
    }

    public void stop() {
        SurveyPlugin surveyPlugin = this;
        PersistableSettings.release();
        PerSessionSettings.release();
        surveyPlugin.unSubscribeOnSDKEvents();
        surveyPlugin.unsubscribeFromMappedTokenChangedEvent();
    }

    public void start(Context context) {
        PoolProvider.postIOTaskWithCheck(() -> {
            SurveyPlugin surveyPlugin = this;
            PersistableSettings.init(context);
            surveyPlugin.initAnnouncementSettings(context);
            surveyPlugin.subscribeOnMappedTokenChangedEvent();
            surveyPlugin.subscribeOnSDKEvents();
        });
    }

    public void wake() {
        this.removeOldSurveys();
        SurveysManager.init();
        if (SurveysManager.getInstance() != null) {
            SurveysManager.getInstance().updateDismissedSurveysSessionCount();
        }
        this.checkAppStatus();
    }

    public void sleep() {
        AnnouncementManager announcementManager = ((SurveyPlugin)((Object)announcementManager)).announcementManager;
        if (announcementManager != null) {
            announcementManager.setAppLatestVersion();
        }
        if (SurveysManager.getInstance() != null) {
            SurveysManager.getInstance().release();
        }
    }

    public long getLastActivityTime() {
        if (PersistableSettings.getInstance() == null) {
            return -1L;
        }
        return PersistableSettings.getInstance().getLastSurveyTime();
    }

    public void onLocaleChanged(Locale locale, Locale locale2) {
        SurveyPlugin surveyPlugin = object;
        super.onLocaleChanged(locale, locale2);
        SurveysSettings.setLastFetchedAt(0L);
        AnnouncementsSettings.getInstance().setLastFetchedAt(0L);
        if (surveyPlugin.shouldReFetch() && object.getAppContext() != null) {
            SurveyPlugin surveyPlugin2 = object;
            Object object = LocaleUtils.resolveLocale((Context)surveyPlugin2.getAppContext(), (Locale)locale2);
            surveyPlugin2.startFetchingAnnouncements((String)object);
            surveyPlugin2.fetchSurveysImmediately((String)object);
        }
    }

    public boolean isFeatureEnabled() {
        return InstabugCore.isFeatureEnabled((String)"SURVEYS");
    }

    @VisibleForTesting
    void subscribeOnSDKEvents() {
        this.getOrCreateDisposables().add(this.subscribeToSDKCoreEvents());
    }

    @VisibleForTesting
    void resolveCountryInfo(CountryInfo countryInfo, boolean bl) {
        if (SurveysUtils.isSurveysFeatureAvailable() && (this = ((Plugin)this).contextWeakReference) != null && ((Reference)this).get() != null && SurveysManager.getInstance() != null) {
            InstabugSDKLogger.d((String)"IBG-Surveys", (String)"Getting Country Code...");
            SurveysManager.getInstance().resolveCountryInfo(countryInfo, bl);
        }
    }

    @VisibleForTesting
    void startFetchingSurveys(String string) {
        if (InstabugCore.isAppOnForeground() && InstabugCore.isFeaturesFetchedBefore() && SurveysUtils.isSurveysFeatureEnabled() && ((SurveyPlugin)((Object)this)).configurationsProvider.isSurveysAvailableAndUsageNotExceeded() && (this = ((Plugin)this).contextWeakReference) != null && ((Reference)this).get() != null && SurveysManager.getInstance() != null) {
            SurveysManager.getInstance().startFetching(string);
        }
    }

    void fetchSurveysImmediately(String string) {
        if (InstabugCore.isAppOnForeground() && InstabugCore.isFeaturesFetchedBefore() && SurveysUtils.isSurveysFeatureEnabled() && ((SurveyPlugin)((Object)this)).configurationsProvider.isSurveysAvailable() && !((SurveyPlugin)((Object)this)).configurationsProvider.isSurveysUsageExceeded() && (this = ((Plugin)this).contextWeakReference) != null && ((Reference)this).get() != null && SurveysManager.getInstance() != null) {
            SurveysManager.getInstance().fetchImmediately(string);
        }
    }

    @VisibleForTesting
    void startFetchingAnnouncements(String string) {
        block7: {
            if (!InstabugCore.isAppOnForeground()) break block7;
            WeakReference weakReference = this.contextWeakReference;
            if (weakReference == null) break block7;
            if (weakReference.get() == null) break block7;
            if (InstabugCore.getFeatureState((String)"ANNOUNCEMENTS") != Feature.State.ENABLED) break block7;
            if (!this.configurationsProvider.isAnnouncementsAvailable()) break block7;
            try {
                AnnouncementManager.getInstance((Context)this.contextWeakReference.get()).startFetching(string);
            }
            catch (Exception exception) {
                IBGDiagnostics.reportNonFatal((Throwable)exception, (String)("Error while fetching and processing announcements: " + exception.getMessage()));
            }
        }
    }

    @VisibleForTesting
    boolean shouldReFetch() {
        return this.getLocaleResolved().equals(SurveysSettings.getLastFetchedLocaleCode()) ^ true;
    }
}

