package com.instabug.survey.ui.popup;

import android.os.Bundle;

import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;

import com.instabug.survey.R;
import com.instabug.survey.models.Survey;

public class PopupCustomizedQuestionFragment extends PopupQuestionFragment {

    public static PopupCustomizedQuestionFragment newInstance(Survey survey) {

        Bundle args = new Bundle();
        args.putSerializable(KEY_SURVEY_ARGUMENT, survey);
        PopupCustomizedQuestionFragment fragment = new PopupCustomizedQuestionFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void showPrimaryQuestion(@Nullable String title, @Nullable String message, String positiveCTA, String negativeCTA) {
        FragmentActivity activity = getActivity();
        if (activity != null) {
            new CustomQuestionDialog.Builder(activity)
                    .setLayoutRes(R.layout.instabug_custom_app_rating_feedback)
                    .setMessage(message)
                    .setPositiveCTA(positiveCTA)
                    .setNegativeCTA(negativeCTA)
                    .setDialogListener(new CustomQuestionDialog.CustomDialogListener() {
                        @Override
                        public void onPositiveActionCalled() {
                            if (presenter != null) {
                                presenter.positivePrimaryOptionClicked();
                            }
                        }

                        @Override
                        public void onNegativeActionCalled() {
                            if (presenter != null) {
                                presenter.showNegativeSecondaryQuestion();
                            }
                        }

                        @Override
                        public void onDismissActionCalled() {
                            if (presenter != null) {
                                presenter.dismissSurvey();
                            }
                        }
                    }).build();
        }
    }

    @Override
    public void showAlertForPositiveSecondaryQuestion(@Nullable String title, @Nullable String message, String positiveCTA, String negativeCTA) {
        FragmentActivity activity = getActivity();
        if (activity != null) {
            new CustomQuestionDialog.Builder(activity)
                    .setLayoutRes(R.layout.instabug_custom_store_rating)
                    .setMessage(message)
                    .setPositiveCTA(positiveCTA)
                    .setNegativeCTA(negativeCTA)
                    .setDialogListener(new CustomQuestionDialog.CustomDialogListener() {
                        @Override
                        public void onPositiveActionCalled() {
                            if (presenter != null) {
                                presenter.positiveSecondaryOptionClicked();
                            }
                        }

                        @Override
                        public void onNegativeActionCalled() {
                            if (presenter != null) {
                                presenter.negativeSecondaryOptionClicked();
                            }
                        }

                        @Override
                        public void onDismissActionCalled() {
                            if (presenter != null) {
                                presenter.submitSurvey();
                            }
                        }
                    }).build();
        }
    }

}
