package com.instabug.survey.ui.custom

import android.view.View
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat
import com.instabug.library.util.AccessibilityUtils
import com.instabug.library.util.ResourcesUtils.getSelectedText

class NPSVirtualViewsProvider(private val npsView: NpsAbstractView) : VirtualViewsInfoProvider {
    override val view: View = npsView

    override fun getPositionAt(x: Float, y: Float): Int = npsView.childPositionAt(x, y)

    override fun getVirtualViews(): List<Int> = (0..10).toList()

    override fun populateNodeForVirtualView(position: Int, info: AccessibilityNodeInfoCompat) =
        with(info) {
            text = getDescriptionForPosition(position)
            setBoundsInParent(npsView.childBoundsAtPosition(position))
        }

    private fun getDescriptionForPosition(position: Int): String =
        "$position ${npsView.resources.getSelectedText(position == npsView.score)}"


    override fun onClickActionForPosition(position: Int) {
        npsView.setScore(position, true)
        AccessibilityUtils.sendTextEvent(getDescriptionForPosition(position))
    }
}
