package com.instabug.survey.settings;

import android.annotation.SuppressLint;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;

import com.instabug.survey.callbacks.OnDismissCallback;
import com.instabug.survey.callbacks.OnFinishCallback;
import com.instabug.survey.callbacks.OnShowCallback;

/**
 * @author tarek
 */
public class PerSessionSettings {

    private static PerSessionSettings perSessionSettings;

    private StringBuilder methodsLog;
    private boolean isSurveysAutoShowing = true;
    private boolean shouldShowSurveysWelcomeScreen = false;
    @Nullable
    private OnShowCallback onShowCallback;
    @Nullable
    private OnDismissCallback onDismissCallback;
    @Nullable
    private OnFinishCallback onFinishCallback;
    private boolean isLiveApp = false;
    @Nullable
    private String lastFetchedLocaleCode;
    @Nullable
    private Boolean isAppStoreRatingEnabled = null;
    private boolean isCustomizationEnabled = false;
    private boolean isLiveAppRequested = false;

    private PerSessionSettings() {
        methodsLog = new StringBuilder();
    }

    @VisibleForTesting
    synchronized static void init() {
        if (perSessionSettings == null)
            perSessionSettings = new PerSessionSettings();
    }

    public synchronized static PerSessionSettings getInstance() {
        if (perSessionSettings == null)
            init();
        return perSessionSettings;
    }

    public StringBuilder getMethodsLog() {
        return methodsLog;
    }

    public void setSurveysAutoShowing(boolean isSurveysAutoShowing) {
        this.isSurveysAutoShowing = isSurveysAutoShowing;
    }

    public boolean isSurveysAutoShowing() {
        return isSurveysAutoShowing;
    }

    @Nullable
    public OnShowCallback getOnShowCallback() {
        return onShowCallback;
    }

    public void setOnShowCallback(@Nullable OnShowCallback onShowCallback) {
        this.onShowCallback = onShowCallback;
    }

    @Nullable
    public OnDismissCallback getOnDismissCallback() {
        return onDismissCallback;
    }

    public void setOnDismissCallback(@Nullable OnDismissCallback onDismissCallback) {
        this.onDismissCallback = onDismissCallback;
    }

    public void setOnFinishCallback(@Nullable OnFinishCallback onFinishCallback) {
        this.onFinishCallback = onFinishCallback;
    }

    @Nullable
    public OnFinishCallback getOnFinishCallback() {
        return onFinishCallback;
    }

    public void setShouldShowSurveysWelcomeScreen(boolean shouldShowWelcomeScreen) {
        this.shouldShowSurveysWelcomeScreen = shouldShowWelcomeScreen;
    }

    public boolean shouldShowWelcomeScreen() {
        return shouldShowSurveysWelcomeScreen;
    }

    void setIsAppLive(boolean isLiveApp) {
        this.isLiveApp = isLiveApp;
    }

    public boolean isAppLive() {
        if (isAppStoreRatingEnabled != null)
            return isAppStoreRatingEnabled;
        return isLiveApp;
    }

    @Nullable
    public String getLastFetchedLocaleCode() {
        return lastFetchedLocaleCode;
    }

    public void setLastFetchedLocaleCode(@Nullable String localeCode) {
        this.lastFetchedLocaleCode = localeCode;
    }

    @SuppressLint("ERADICATE_FIELD_NOT_NULLABLE")
    public synchronized static void release() {
        perSessionSettings = null;
    }

    public void setIsAppStoreRatingEnabled(boolean isAppStoreRatingEnabled) {
        this.isAppStoreRatingEnabled = isAppStoreRatingEnabled;
    }

    @Nullable
    public Boolean isAppStoreRatingEnabled() {
        return isAppStoreRatingEnabled;
    }

    public void enableCustomization() {
        this.isCustomizationEnabled = true;
    }

    public boolean isCustomizationEnabled() {
        return isCustomizationEnabled;
    }

    /**
     * Method to check if the isLiveApp google request was done or not
     *
     * @return
     */
    public boolean isLiveAppRequested() {
        return isLiveAppRequested;
    }

    /**
     * Method to set isLiveAppRequest field true
     *
     * @return
     */
    public void setIsLiveAppRequestedTrue() {
        isLiveAppRequested = true;
    }
}
