package com.instabug.survey.common.models;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.survey.models.UserInteractionOnTypes;

import java.io.Serializable;

public class UserInteraction implements Serializable {


    private long surveyId;
    @Nullable
    private String uuid;
    private Target target;
    @UserInteractionOnTypes
    private int actionOnType;
    private boolean answered;
    private long dismissedAt;
    private long shownAt;
    private boolean isCancelled;
    private int attemptCount;
    private int eventIndex;
    private boolean isAlreadyShown;
    /**
     * session counter to evaluate showing survey after being dismissed
     */
    private int sessionCounter = 0;
    private boolean shouldShowAgain;
    private SyncingStatus surveyState;

    public UserInteraction(@UserInteractionOnTypes int actionOnType) {
        this.actionOnType = actionOnType;
        answered = false;
        isCancelled = false;
        surveyState = SyncingStatus.NOT_AVAILABLE;
        shouldShowAgain = true;
        target = new Target();
        eventIndex = -1;
        attemptCount = -1;
    }


    public long getSurveyId() {
        return surveyId;
    }

    public void setSurveyId(long surveyId) {
        this.surveyId = surveyId;
    }

    @Nullable
    public String getUuid() {
        return uuid;
    }

    public void setUuid(@NonNull String uuid) {
        this.uuid = uuid;
    }

    public Target getTarget() {
        return target;
    }

    public int getActionOnType() {
        return actionOnType;
    }

    public void setActionOnType(@UserInteractionOnTypes int actionOnType) {
        this.actionOnType = actionOnType;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public int getEventIndex() {
        return eventIndex;
    }

    public void setEventIndex(int eventIndex) {
        this.eventIndex = eventIndex;
    }

    public int getAttemptCount() {
        return attemptCount;
    }

    public void setAttemptCount(int attemptCount) {
        this.attemptCount = attemptCount;
    }

    public boolean isCancelled() {
        return isCancelled;
    }

    public void setCancelled(boolean cancelled) {
        isCancelled = cancelled;
    }

    public long getShownAt() {
        return shownAt;
    }

    public void setShownAt(long shownAt) {
        this.shownAt = shownAt;
    }

    public long getDismissedAt() {
        return dismissedAt;
    }

    public void setDismissedAt(long dismissedAt) {
        this.dismissedAt = dismissedAt;
    }

    public boolean isAnswered() {
        return answered;
    }

    public void setAnswered(boolean answered) {
        this.answered = answered;
    }

    public int getSessionCounter() {
        return sessionCounter;
    }

    public void setSessionCounter(int sessionCounter) {
        this.sessionCounter = sessionCounter;
    }

    public void setShouldShowAgain(boolean shouldShowAgain) {
        this.shouldShowAgain = shouldShowAgain;
    }

    public boolean isShouldShowAgain() {
        return shouldShowAgain;
    }


    public SyncingStatus getSurveyState() {
        return surveyState;
    }

    public void setSurveyState(SyncingStatus surveyState) {
        this.surveyState = surveyState;
    }

    public int incrementEventIndex() {
        return ++eventIndex;
    }

    private int getAttempt() {
        return attemptCount++;
    }

    public void incrementSessionCount() {
        setSessionCounter(++sessionCounter);
    }


    public void incrementAttemptCount() {
        ++attemptCount;
    }

    public boolean isAlreadyShown() {
        return isAlreadyShown;
    }

    public void setAlreadyShown(boolean alreadyShown) {
        isAlreadyShown = alreadyShown;
    }
}
