package com.instabug.survey.common.models;

import androidx.annotation.IntDef;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Created by Barakat on 25/11/2018
 */
public class Trigger implements Serializable {

    public static final int DEFAULT_TRIGGER_TIME = 10000;
    public static final int TIMED_SHOWING_TRIGGER = 0;
    private static final String KEY_TRIGGER_TYPE = "trigger_type";
    private static final String KEY_USER_EVENT = "user_event";
    private static final String KEY_TRIGGER_AFTER = "trigger_after";
    private static final String KEY_TRIGGER_STATUS = "trigger_status";


    private @TriggerStatus
    int triggerStatus = TriggerStatus.TRIGGER_PENDING;
    private int triggerType;
    @Nullable
    private String userEvent;
    private int triggerAfter = DEFAULT_TRIGGER_TIME;

    Trigger() {
    }

    public static Trigger getFromJson(String jsonString) throws JSONException {
        Trigger trigger = new Trigger();
        trigger.fromJson(jsonString);
        return trigger;
    }

    public void fromJson(String modelAsJson) throws JSONException {
        JSONObject jsonObject = new JSONObject(modelAsJson);
        setTriggerType(jsonObject.optInt(KEY_TRIGGER_TYPE, TIMED_SHOWING_TRIGGER));
        setTriggerAfter(jsonObject.optInt(KEY_TRIGGER_AFTER, DEFAULT_TRIGGER_TIME));
        if (jsonObject.has(KEY_USER_EVENT)) {
            setUserEvent(jsonObject.getString(KEY_USER_EVENT));
        }
        if (jsonObject.has(KEY_TRIGGER_STATUS)) {
            setTriggerStatus(jsonObject.getInt(KEY_TRIGGER_STATUS));
        }
        if (jsonObject.has(KEY_TRIGGER_AFTER)) {
            setTriggerAfter(jsonObject.getInt(KEY_TRIGGER_AFTER));
        }
    }

    public int getTriggerAfter() {
        return triggerAfter;
    }

    public void setTriggerAfter(int triggerAfter) {
        this.triggerAfter = triggerAfter;
    }

    public int getTriggerType() {
        return triggerType;
    }

    public void setTriggerType(int triggerType) {
        this.triggerType = triggerType;
    }

    @NonNull
    public String getUserEvent() {
        if (userEvent == null) {
            return "";
        }
        return userEvent;
    }

    public void setUserEvent(@Nullable String userEvent) {
        this.userEvent = userEvent;
    }

    public @TriggerStatus
    int getTriggerStatus() {
        return triggerStatus;
    }

    public void setTriggerStatus(@TriggerStatus int triggerStatus) {
        this.triggerStatus = triggerStatus;
    }

    public JSONObject toJson() throws JSONException {
        return new JSONObject()
                .put(KEY_USER_EVENT, userEvent)
                .put(KEY_TRIGGER_TYPE, triggerType)
                .put(KEY_TRIGGER_AFTER, triggerAfter)
                .put(KEY_TRIGGER_STATUS, triggerStatus);
    }

    @Retention(RetentionPolicy.RUNTIME)
    @IntDef({
            TriggerStatus.TRIGGER_PENDING,
            TriggerStatus.TRIGGER_READY
    })
    public @interface TriggerStatus {
        int TRIGGER_PENDING = 0;
        int TRIGGER_READY = 1;
    }
}
