package com.instabug.survey.common;

import android.app.Activity;

import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.util.DisplayUtils;
import com.instabug.library.util.OrientationUtils;
import com.instabug.survey.ui.ViewType;

/**
 * Created by Barakat on 10/01/2019
 */
public class LayoutUtils {

    public static int getLayoutHeight(Activity activity, ViewType viewType) {
        int heightInPx = DisplayUtils.getDisplayHeightInPx(activity);
        switch (viewType) {
            default:
            case PARTIAL:
                if (OrientationUtils.isInLandscape(activity)) {
                    if (InstabugDeviceProperties.isTablet(activity)) {
                        heightInPx = ((heightInPx * 40) / 100);
                    } else {
                        heightInPx = ((heightInPx * 45) / 100);
                    }
                } else {
                    if (InstabugDeviceProperties.isTablet(activity)) {
                        heightInPx = ((heightInPx * 25) / 100);
                    } else {
                        heightInPx = ((heightInPx * 38) / 100);
                    }
                }
                break;
            case PRIMARY:
                if (InstabugDeviceProperties.isTablet(activity)) {
                    if (OrientationUtils.isInLandscape(activity)) {
                        heightInPx = ((heightInPx * 60) / 100);
                    } else {
                        heightInPx = ((heightInPx * 45) / 100);
                    }
                } else {
                    if (OrientationUtils.isInLandscape(activity)) {
                        heightInPx = ((heightInPx * 75) / 100);
                    } else {
                        heightInPx = ((heightInPx * 52) / 100);
                    }
                }
                break;
            case SECONDARY:
                if (InstabugDeviceProperties.isTablet(activity)) {
                    heightInPx = ((heightInPx * 80) / 100);
                } else if (OrientationUtils.isInLandscape(activity)) {
                    heightInPx = ((heightInPx * 95) / 100);
                } else {
                    heightInPx = ((heightInPx * 88) / 100);
                }
                break;
        }

        float fontScale = activity.getResources().getConfiguration().fontScale;

        return (int) (heightInPx * fontScale);
    }
}
