package com.instabug.survey.announcements.models;

import androidx.annotation.Nullable;

import com.instabug.library.internal.storage.cache.Cacheable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * Created by Barakat on 20/12/2018
 */
public class NewFeature implements Serializable, Cacheable {

    // Serialization keys
    private static final String KEY_ID = "id";
    private static final String KEY_TITLE = "title";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_ICON_URL = "icon_url";

    private long id;
    @Nullable
    private String title;
    @Nullable
    private String description;
    @Nullable
    private String iconUrl;

    private NewFeature() {
    }

    public static ArrayList<NewFeature> fromJson(JSONArray featuresJsonArray) throws JSONException {
        ArrayList<NewFeature> newFeaturesList = new ArrayList<>();
        for (int i = 0; i < featuresJsonArray.length(); i++) {
            JSONObject featureJSONObject = featuresJsonArray.getJSONObject(i);
            NewFeature newFeature = new NewFeature();
            newFeature.fromJson(featureJSONObject.toString());
            newFeaturesList.add(newFeature);
        }
        return newFeaturesList;
    }

    public static JSONArray toJson(@Nullable ArrayList<NewFeature> featureArrayList) throws JSONException {
        JSONArray newFeaturesJSONArray = new JSONArray();
        if (featureArrayList != null) {
            for (NewFeature newFeature : featureArrayList) {
                newFeaturesJSONArray.put(new JSONObject(newFeature.toJson()));
            }
        }
        return newFeaturesJSONArray;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(KEY_ID, getId())
                .put(KEY_TITLE, title)
                .put(KEY_DESCRIPTION, description)
                .put(KEY_ICON_URL, iconUrl);
        return jsonObject.toString();
    }

    @Override
    public void fromJson(String modelAsJson) throws JSONException {
        JSONObject jsonObject = new JSONObject(modelAsJson);
        if (jsonObject.has(KEY_ID)) {
            this.setId(jsonObject.getLong(KEY_ID));
        } else {
            this.setId(-1L);
        }
        if (jsonObject.has(KEY_TITLE)) {
            this.setTitle(jsonObject.getString(KEY_TITLE));
        }
        if (jsonObject.has(KEY_DESCRIPTION)) {
            this.setDescription(jsonObject.getString(KEY_DESCRIPTION));
        }
        this.setIconUrl(jsonObject.optString(KEY_ICON_URL, ""));
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Nullable
    public String getTitle() {
        return title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Nullable
    public String getDescription() {
        return description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Nullable
    public String getIconUrl() {
        return iconUrl;
    }

    private void setIconUrl(@Nullable String iconUrl) {
        this.iconUrl = iconUrl;
    }
}
