package com.instabug.survey.ui.gestures;

import android.view.GestureDetector;
import android.view.MotionEvent;

import com.instabug.library.Instabug;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.util.InstabugSDKLogger;

public final class GestureListener extends GestureDetector.SimpleOnGestureListener {

    private static final int SWIPE_THRESHOLD = 300;
    private static final int SWIPE_VELOCITY_THRESHOLD = 800;

    private final GesturesCallback gesturesCallback;

    public GestureListener(GesturesCallback gesturesCallback) {
        this.gesturesCallback = gesturesCallback;
    }

    @Override
    public boolean onDown(MotionEvent e) {
        return true;
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent e) {
        gesturesCallback.onClick();
        return super.onSingleTapConfirmed(e);
    }

    @Override
    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        boolean result = false;
        try {
            float diffY = e2.getY() - e1.getY();
            float diffX = e2.getX() - e1.getX();
            if (Math.abs(diffX) > Math.abs(diffY)) {
                if (Math.abs(diffX) > SWIPE_THRESHOLD && Math.abs(velocityX) > SWIPE_VELOCITY_THRESHOLD) {
                    if (diffX > 0) {
                        gesturesCallback.onSwipeRight();
                    } else {
                        gesturesCallback.onSwipeLeft();
                    }
                    result = true;
                }
            } else if (Math.abs(diffY) > SWIPE_THRESHOLD && Math.abs(velocityY) > SWIPE_VELOCITY_THRESHOLD) {
                if (diffY > 0) {
                    if (Math.abs(velocityY) > getVelocity()) {
                        gesturesCallback.onHardSwipeDown();
                    }
                } else {
                    if (Math.abs(velocityY) > getVelocity()) {
                        gesturesCallback.onHardSwipeUp();
                    }
                }
                result = true;
            }


        } catch (Exception exception) {
        }
        return result;
    }

    private float getVelocity() {
        if(Instabug.getApplicationContext() == null) return 6000;

        return InstabugDeviceProperties.isTablet(Instabug.getApplicationContext()) ? 3000 : 6000;
    }

    public interface GesturesCallback {
        void onSwipeRight();

        void onSwipeLeft();

        void onHardSwipeUp();

        void onHardSwipeDown();

        void onClick();
    }

}