package com.instabug.survey.ui.custom

import android.content.res.Resources
import android.view.View
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat
import com.instabug.library.util.AccessibilityUtils
import com.instabug.library.util.ResourcesUtils.getSelectedText
import com.instabug.survey.R

class RatingVirtualViewsProvider(
    private val ratingView: RatingAbstractView,
) : VirtualViewsInfoProvider {

    override val view: View = ratingView
    override fun getPositionAt(x: Float, y: Float): Int = ratingView.childPositionAt(x, y)

    override fun getVirtualViews(): List<Int> = (1..5).toList()

    override fun populateNodeForVirtualView(
        position: Int,
        info: AccessibilityNodeInfoCompat
    ) = with(info) {
        text = view.resources.getDescriptionForPosition(position)
        setBoundsInParent(ratingView.childBoundsAtPosition(position))
    }

    private fun Resources.getDescriptionForPosition(position: Int): String =
        "$position ${label(position)} of 5 ${getSelectedText(position <= ratingView.rating)}"

    private fun Resources.label(position: Int) = if (position == 1)
        getString(R.string.ib_star)
    else
        getString(R.string.ib_stars)

    override fun onClickActionForPosition(position: Int) {
        ratingView.setRating(position.toFloat(), true)
        AccessibilityUtils.sendTextEvent(view.resources.getDescriptionForPosition(position))
    }
}
