package com.instabug.survey.settings;

import androidx.annotation.Nullable;

import com.instabug.library.Feature;
import com.instabug.library.IBGFeature;
import com.instabug.library.core.InstabugCore;
import com.instabug.survey.callbacks.OnDismissCallback;
import com.instabug.survey.callbacks.OnFinishCallback;
import com.instabug.survey.callbacks.OnShowCallback;

import java.util.concurrent.TimeUnit;

public class SurveysSettings {
    public static final String CURRENT_VERSION = "2";
    public static final String LOCALE = "locale";
    public static final long DELAY_BEFORE_SHOWING = 10000L;
    public static final long DEFAULT_COUNTRY_RESOLVER_INTERVAL = TimeUnit.DAYS.toMillis(7);
    private static final int RESHOW_DISMISSED_SURVEY_DEFAULT_COUNT = 4;

    public static void setSurveysAutoShowing(boolean isSurveysAutoShowing) {
        PerSessionSettings.getInstance().setSurveysAutoShowing(isSurveysAutoShowing);
    }

    public static boolean isSurveysAutoShowing() {
        return PerSessionSettings.getInstance().isSurveysAutoShowing();
    }

    @Nullable
    public static OnShowCallback getOnShowCallback() {
        return PerSessionSettings.getInstance().getOnShowCallback();
    }

    public static void setOnShowCallback(OnShowCallback onShowCallback) {
        PerSessionSettings.getInstance().setOnShowCallback(onShowCallback);
    }

    @Nullable
    public static OnDismissCallback getOnDismissCallback() {
        return PerSessionSettings.getInstance().getOnDismissCallback();
    }

    public static void setOnDismissCallback(OnDismissCallback onDismissCallback) {
        PerSessionSettings.getInstance().setOnDismissCallback(onDismissCallback);
    }

    public static void setOnFinishCallback(OnFinishCallback onFinishCallback) {
        PerSessionSettings.getInstance().setOnFinishCallback(onFinishCallback);
    }

    @Nullable
    public static OnFinishCallback getOnFinishCallback() {
        return PerSessionSettings.getInstance().getOnFinishCallback();
    }

    public static void setShouldShowSurveysWelcomeScreen(boolean shouldShowWelcomeScreen) {
        PerSessionSettings.getInstance().setShouldShowSurveysWelcomeScreen(shouldShowWelcomeScreen);
    }

    public static Boolean shouldShowSurveysWelcomeScreen() {
        return PerSessionSettings.getInstance().shouldShowWelcomeScreen();
    }

    public static void setIsAppLive(boolean isLiveApp) {
        PerSessionSettings.getInstance().setIsAppLive(isLiveApp);
    }

    public static boolean isAppLive() {
        return PerSessionSettings.getInstance().isAppLive()
                && PerSessionSettings.getInstance().isLiveAppRequested();
    }

    public static void setIsLiveAppRequestedTrue() {
        PerSessionSettings.getInstance().setIsLiveAppRequestedTrue();
    }

    public static void setIsAppStoreRatingEnabled(boolean isAppStoreRatingEnabled) {
        PerSessionSettings.getInstance().setIsAppStoreRatingEnabled(isAppStoreRatingEnabled);
    }

    /**
     * to void making a request to play.google and use hardcoded flag provided by the user.
     *
     * @return null if the user nevered used this API
     * @see {Surveys.setIsAppPubliclyReleased()}
     */
    @Nullable
    public static Boolean isAppStoreRatingEnabled() {
        return PerSessionSettings.getInstance().isAppStoreRatingEnabled();
    }

    public static void enableCustomization() {
        PerSessionSettings.getInstance().enableCustomization();
    }

    /**
     * ANDs the user enabled customization settings with BE feature availability
     *
     * @return
     */
    public static boolean isCustomizationEnabled() {
        return PerSessionSettings.getInstance().isCustomizationEnabled() && InstabugCore.isFeatureAvailable(IBGFeature.VZ_MESSAGES_CUSTOM_APPRATING_UI);
    }


    public static void setLastFetchedAt(long time) {
        if (PersistableSettings.getInstance() == null) return;

        PersistableSettings.getInstance().setLastFetchedAt(time);
    }

    public static long getLastFetchedAt() {
        if (PersistableSettings.getInstance() == null) return -1;
        return PersistableSettings.getInstance().getLastFetchedAt();
    }

    public static int getSurveysReshowSessionCount() {
        return RESHOW_DISMISSED_SURVEY_DEFAULT_COUNT;
    }

    /**
     * check if we already deleted the old surveys cache files or not
     */
    public static boolean hasBeenMigrated() {
        if (PersistableSettings.getInstance() == null) return false;
        return PersistableSettings.getInstance().hasBeenMigrated();
    }

    /**
     * mark old cache files deleted successfully
     */
    public static void markSurveysFilesMigrated() {
        if (PersistableSettings.getInstance() == null) return;
        PersistableSettings.getInstance().markSurveysFilesMigrated();
    }

    public static long getFirstSeen() {
        return InstabugCore.getFirstSeen();
    }

    public static void setCountryInfo(String countryInfo) {
        if (PersistableSettings.getInstance() == null) return;
        PersistableSettings.getInstance().setCountryCode(countryInfo);
    }

    public static void setCountryInfoLastFetch(long timestamp) {
        if (PersistableSettings.getInstance() == null) return;
        PersistableSettings.getInstance().setCountryCodeLastFetch(timestamp);
    }

    @Nullable
    public static String getCountryInfo() {
        if (PersistableSettings.getInstance() == null) return null;
        return PersistableSettings.getInstance().getCountryCode();
    }

    public static long getCountyInfoLastFetch() {
        if (PersistableSettings.getInstance() == null) return -1;
        return PersistableSettings.getInstance().getCountryCodeLastFetch();
    }

    @Nullable
    public static String getLastFetchedLocaleCode() {
        if (PersistableSettings.getInstance() == null) return null;
        return PerSessionSettings.getInstance().getLastFetchedLocaleCode();
    }

    public static void setLastFetchedLocaleCode(String localeCode) {
        if (PersistableSettings.getInstance() == null) return;
        PerSessionSettings.getInstance().setLastFetchedLocaleCode(localeCode);
    }
}
