package com.instabug.survey.announcements.ui.activity;

import com.instabug.library.core.ui.BaseContract;
import com.instabug.survey.announcements.models.Announcement;

import androidx.appcompat.app.AppCompatActivity;

public interface AnnouncementActivityContract {
    interface View extends BaseContract.View<AppCompatActivity> {

        void setFrameLayoutHeightTo(int height);

        void finishAnnouncement(boolean showThanksFragment);

        void setFrameLayoutHeightWithAnimation(int heightInPx);
    }

    interface Presenter {

        void setLayoutHeightSecondary(boolean withAnimation);

        void submitAnnouncement(Announcement announcement);

        void dismissAnnouncement(Announcement announcement);
    }
}

