package com.instabug.survey.utils;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.StringDef;

import static com.instabug.survey.utils.TargetingOperator.AND;
import static com.instabug.survey.utils.TargetingOperator.CONTAINS;
import static com.instabug.survey.utils.TargetingOperator.EQUAL;
import static com.instabug.survey.utils.TargetingOperator.GREATER_THAN;
import static com.instabug.survey.utils.TargetingOperator.LESS_THAN;
import static com.instabug.survey.utils.TargetingOperator.NOT_CONTAINS;
import static com.instabug.survey.utils.TargetingOperator.NOT_EQUAL;
import static com.instabug.survey.utils.TargetingOperator.OR;

@Retention(RetentionPolicy.SOURCE)
@StringDef({EQUAL, NOT_EQUAL, GREATER_THAN, LESS_THAN, CONTAINS, NOT_CONTAINS, AND, OR})
public @interface TargetingOperator {

    String EQUAL = "equal";
    String NOT_EQUAL = "not_equal";
    String GREATER_THAN = "greater_than";
    String LESS_THAN = "less_than";
    String CONTAINS = "contain";
    String NOT_CONTAINS = "not_contain";
    String AND = "and";
    String OR = "or";
}
