package com.instabug.survey.ui.gestures;

import android.animation.ValueAnimator;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;

import java.lang.ref.WeakReference;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Created by zak on 1/29/18.
 */

public class GesturesHandler {
    public final static String TAG = "SurveysGesturesHandler";
    private static final float EXPAND_THRETHOLD_MAX_PERCENT = 2f;
    private static final float DISMISS_THRETHOLD_PERCENT = 0.70f;
    private static final float EXPAND_THRETHOLD_PERCENT = 1.4f;

    private static int CLICK_ACTION_THRESHOLD = 5;

    private static boolean isClosing = false;

    private static float lastDragingPosition = -1;
    private static int originalHeight = -1;
    // for calculating click
    private static float startX;
    private static float startY;

    @Nullable
    private static WeakReference<GestureCallback> gestureCallback;

    public static void handle(View view, MotionEvent event,
                              boolean isPartial, boolean isWelcomePage,
                              @NonNull GestureCallback gestureCallback) {
        if (GesturesHandler.gestureCallback == null || GesturesHandler.gestureCallback.get() == null) {
            GesturesHandler.gestureCallback = new WeakReference<>(gestureCallback);
        }

        View parentView;
        if (isPartial) {
            parentView = ((View) view.getParent());
        } else {
            parentView = ((View) view.getParent().getParent().getParent().getParent());
        }
        ViewGroup.LayoutParams params = parentView.getLayoutParams();
        if (originalHeight == -1)
            originalHeight = params.height;

        handleMotionEvent(event, isPartial, isWelcomePage, gestureCallback, parentView, params);
    }


    public static void handleAnnouncementView(View view, MotionEvent event,
                                              @NonNull GestureCallback gestureCallback) {
        if (GesturesHandler.gestureCallback == null || GesturesHandler.gestureCallback.get() == null) {
            GesturesHandler.gestureCallback = new WeakReference<>(gestureCallback);
        }
        View parentView = (View) view.getParent();
        ViewGroup.LayoutParams params = parentView.getLayoutParams();
        if (originalHeight == -1)
            originalHeight = params.height;

        handleMotionEvent(event, false, false, gestureCallback, parentView, params);
    }

    public static void handleMotionEvent(MotionEvent event, boolean isPartial, boolean isWelcomePage,
                                         @NonNull GestureCallback gestureCallback, View view, ViewGroup.LayoutParams params) {
        switch (event.getActionMasked()) {
            case MotionEvent.ACTION_DOWN:

                startX = event.getX();
                startY = event.getY();

                lastDragingPosition = event.getRawY();
                break;

            case MotionEvent.ACTION_MOVE:
                if (isWelcomePage) {
                    if (lastDragingPosition < event.getRawY()) {
                        // swipe down
                        params.height = (int) (params.height - (event.getRawY() - lastDragingPosition));
                        view.setLayoutParams(params);
                        lastDragingPosition = event.getRawY();
                    } else if (lastDragingPosition > event.getRawY()) {
                        // swipe up
                        if (params.height < originalHeight) {
                            params.height = (int) (params.height + (lastDragingPosition - event.getRawY()));
                            view.setLayoutParams(params);
                            lastDragingPosition = event.getRawY();
                        }
                    }
                } else if (isPartial) {
                    if (lastDragingPosition < event.getRawY()) {
                        // swipe down
                        params.height = (int) (params.height - (event.getRawY() - lastDragingPosition));
                        view.setLayoutParams(params);
                        lastDragingPosition = event.getRawY();
                    } else if (lastDragingPosition > event.getRawY()) {
                        // swipe up
                        params.height = (int) (params.height + (lastDragingPosition - event.getRawY()));
                        view.setLayoutParams(params);
                        lastDragingPosition = event.getRawY();
                    }
                } else {
                    if (lastDragingPosition < event.getRawY()) {
                        params.height = (int) (params.height - (event.getRawY() - lastDragingPosition));
                        view.setLayoutParams(params);
                        lastDragingPosition = event.getRawY();
                    } else if (lastDragingPosition > event.getRawY()) {
                        if (params.height < originalHeight) {
                            params.height = (int) (params.height + (lastDragingPosition - event.getRawY()));
                            view.setLayoutParams(params);
                        }
                        lastDragingPosition = event.getRawY();
                    }
                }
                if (isPartial) {
                    if (((float) params.height / originalHeight) > EXPAND_THRETHOLD_MAX_PERCENT) {
                        if (!isWelcomePage) {
                            gestureCallback.onClick();
                            isClosing = false;
                        }
                    } else {
                        isClosing = false;
                    }
                } else {
                    if (((float) params.height / originalHeight) < DISMISS_THRETHOLD_PERCENT) {
                        isClosing = true;
                        gestureCallback.close();
                        originalHeight = -1;
                    } else {
                        isClosing = false;
                    }
                }
                break;
            case MotionEvent.ACTION_UP:
                boolean isClickedOrAnimated = false;
                float endX = event.getX();
                float endY = event.getY();
                if (isAClick(startX, endX, startY, endY) && isPartial && !isClosing) {
                    if (!isWelcomePage) {
                        gestureCallback.onClick();
                        isClickedOrAnimated = true;
                        isClosing = true;
                        originalHeight = -1;
                    }
                }

                if (!isClosing) {
                    if (isPartial) {
                        if (originalHeight != params.height && originalHeight > params.height) {
                            if (((float) params.height / originalHeight) < DISMISS_THRETHOLD_PERCENT) {
                                isClosing = true;
                                gestureCallback.close();
                                originalHeight = -1;
                            } else {
                                animateBackToOriginalHeight(view, params.height, originalHeight);
                                isClickedOrAnimated = true;
                            }
                        } else if (originalHeight != params.height && originalHeight < params.height) {
                            if ((float) params.height / originalHeight > EXPAND_THRETHOLD_PERCENT) {
                                if (!isWelcomePage) {
                                    gestureCallback.onClick();
                                    originalHeight = -1;
                                }
                            } else {
                                animateBackToOriginalHeight(view, params.height, originalHeight);
                            }
                            isClickedOrAnimated = true;
                        }
                    } else {
                        if (originalHeight != params.height && originalHeight > params.height) {
                            animateBackToOriginalHeight(view, params.height, originalHeight);
                            isClickedOrAnimated = true;
                        }
                    }
                }

                if (isClickedOrAnimated)
                    originalHeight = -1;

                break;
            default:
                break;
        }
    }

    private static void animateBackToOriginalHeight(final View view, int currentHeight, int originalHeight) {
        ValueAnimator anim = ValueAnimator.ofInt(currentHeight, originalHeight);
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            @Override
            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer) valueAnimator.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                layoutParams.height = val;
                view.setLayoutParams(layoutParams);
            }
        });
        anim.setDuration(300);
        anim.start();
    }

    private static boolean isAClick(float startX, float endX, float startY, float endY) {
        float differenceX = Math.abs(startX - endX);
        float differenceY = Math.abs(startY - endY);
        return !(differenceX > CLICK_ACTION_THRESHOLD/* =5 */ || differenceY > CLICK_ACTION_THRESHOLD);
    }

    public static void reset() {
        originalHeight = -1;
        lastDragingPosition = -1;
    }

    public static void destroy() {
        if (gestureCallback != null) {
            gestureCallback.clear();
        }
    }

    public interface GestureCallback {
        void onClick();

        void close();
    }

}
