package com.instabug.survey.announcements.ui.fragment.versionupdate;

import com.instabug.library.core.ui.BaseContract;
import com.instabug.survey.announcements.models.AnnouncementItem;

import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;


/**
 Created by Barakat on 30/12/2018
 */
public interface UpdateMessageContract {
    interface View extends BaseContract.View<Fragment> {

        void showOptionalUpdateAnnouncement(@Nullable String title, @Nullable String message, @Nullable String positiveOption, String negativeOption);

        void showMandatoryUpdateAnnouncement(@Nullable String title, @Nullable String message, @Nullable String positiveOption);

        void onPositiveOptionClicked();

        void onNegativeOptionClicked();

        void onAnnouncementItemHasConfigLink(String androidLink);

        void onAnnouncementItemDoesNotHaveConfigLink();
    }

    interface Presenter extends BaseContract.Presenter {

        void showVersionUpdateAnnouncement(AnnouncementItem announcementItem);

        void handleOptionalUpdateAnnouncement(AnnouncementItem announcementItem);

        void handelMandatoryUpdateAnnouncement(AnnouncementItem announcementItem);
    }
}
