package com.instabug.survey.utils;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.StringDef;

import static com.instabug.survey.utils.TargetingCondition.APP_VERSION;
import static com.instabug.survey.utils.TargetingCondition.APP_VERSION_V2;
import static com.instabug.survey.utils.TargetingCondition.COUNTRY;
import static com.instabug.survey.utils.TargetingCondition.DATE;
import static com.instabug.survey.utils.TargetingCondition.DAYS_SINCE_DISMISS;
import static com.instabug.survey.utils.TargetingCondition.DAYS_SINCE_SIGN_UP;
import static com.instabug.survey.utils.TargetingCondition.LAST_SEEN;
import static com.instabug.survey.utils.TargetingCondition.OS_API_LEVEL;
import static com.instabug.survey.utils.TargetingCondition.SESSION_COUNT;
import static com.instabug.survey.utils.TargetingCondition.USER_EMAIL;

@Retention(RetentionPolicy.SOURCE)
@StringDef({APP_VERSION, APP_VERSION_V2, DATE, USER_EMAIL, DAYS_SINCE_DISMISS, SESSION_COUNT,
        DAYS_SINCE_SIGN_UP, COUNTRY, LAST_SEEN, OS_API_LEVEL})
public @interface TargetingCondition {

    @Deprecated
    String APP_VERSION = "app_version";
    String APP_VERSION_V2 = "app_version_v2";
    String DATE = "date";
    String USER_EMAIL = "email";
    String DAYS_SINCE_DISMISS = "days_since_dismiss";
    String SESSION_COUNT = "sessions_count";
    String DAYS_SINCE_SIGN_UP = "days_since_signup";
    String COUNTRY = "country";
    String LAST_SEEN = "last_seen";
    String OS_API_LEVEL = "android_version";
}
