package com.instabug.survey.utils;

import com.instabug.library.util.TimeUtils;
import com.instabug.survey.common.models.Frequency;
import com.instabug.survey.common.models.Target;
import com.instabug.survey.models.Survey;

import java.util.concurrent.TimeUnit;

/**
 * Created by Barakat on 27/02/2019
 */
public class FrequencyProcessor {

    FrequencyProcessor() {
    }

    boolean isFrequentSurvey(Survey survey) {
        return checkFrequencyValidity(survey);
    }

    boolean checkFrequencyValidity(Survey survey) {
        Target target = survey.getTarget();
        Frequency frequency = target.getFrequency();
        int type = frequency.getType();
        boolean shouldReshowAfterDismiss = survey.shouldReshowAfterDismiss();
        if (type == Frequency.Type.SHOW_ONCE) {


            return shouldReshowAfterDismiss ||
                    (!survey.isPaused() &&
                            !survey.isAnswered() &&
                            !survey.isCancelled() &&
                            !survey.isLastEventDismiss());
        } else {
            // else use the frequency to reshow the survey
            int showingInterval = frequency.getShowingInterval();
            int durationSinceLastShow = getDifferenceDays(survey.getShownAt() * 1000, TimeUtils.currentTimeMillis());
            boolean isReshowingSurvey = frequency.getType() == Frequency.Type.SHOW_WITH_INTERVAL;

            return shouldReshowAfterDismiss ||
                    (isReshowingSurvey &&
                            durationSinceLastShow >= showingInterval);
        }
    }

    int getDifferenceDays(long time, long currentTime) {
        return (int) TimeUnit.DAYS.convert(currentTime - time, TimeUnit.MILLISECONDS);
    }

}
