package com.instabug.survey.utils;

import java.util.concurrent.TimeUnit;

/**
 * Created by mohamedzakaria on 5/30/17.
 */

public class DateUtils {
    /**
     * return difference in days between the passed time and the current system time
     * @param time in millis
     * @return difference in days
     */
    public static int getDifferenceInDays(long time) {
        long now = System.currentTimeMillis();

        final long diff = (now - time);

        return (int) TimeUnit.MILLISECONDS.toDays(diff);
    }

    /**
     * return difference in days between the passed time and the current system time
     * @param time in seconds
     * @return difference in days
     */
    public static int getDifferenceInDaysFromSeconds(long time) {
        long now = System.currentTimeMillis()/ 1000;

        final long diff = (now - time);
        return (int) TimeUnit.SECONDS.toDays(diff);
    }

}