package com.instabug.survey.announcements.ui.fragment.versionupdate;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.View;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;

import com.instabug.library.ui.custom.InstabugAlertDialog;
import com.instabug.survey.R;
import com.instabug.survey.announcements.models.AnnouncementItem;
import com.instabug.survey.announcements.ui.activity.AnnouncementActivity;
import com.instabug.survey.announcements.ui.activity.AnnouncementActivityCallback;
import com.instabug.survey.announcements.ui.activity.AnnouncementNavigator;
import com.instabug.survey.announcements.ui.fragment.AnnouncementItemFragment;
import com.instabug.survey.utils.PlayStoreUtils;

/**
 * Created by Barakat on 30/12/2018
 */
public class UpdateMessageFragment extends AnnouncementItemFragment<UpdateMessagePresenter> implements
        UpdateMessageContract.View {

    private UpdateMessagePresenter presenter;
    @Nullable
    private AnnouncementActivityCallback activityCallback;
    @Nullable
    private AlertDialog alertDialog;
    @Nullable
    private DialogInterface.OnClickListener dialogPositiveClickListener;
    @Nullable
    private DialogInterface.OnClickListener dialogNegativeClickListener;

    public static UpdateMessageFragment newInstance(AnnouncementItem announcementItem) {
        Bundle args = new Bundle();
        args.putSerializable(KEY_ANNOUNCE_ARGUMENT, announcementItem);
        UpdateMessageFragment fragment = new UpdateMessageFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRetainInstance(true);
        if (getArguments() != null)
            announcementItem = (AnnouncementItem) getArguments().getSerializable(KEY_ANNOUNCE_ARGUMENT);

        presenter = new UpdateMessagePresenter(this);
    }

    @Override
    protected void initViews(View rootView, @Nullable Bundle savedInstanceState) {
        super.initViews(rootView, savedInstanceState);
        container = rootView.findViewById(R.id.instabug_announcement_dialog_container);
        if (announcementItem != null)
            presenter.showVersionUpdateAnnouncement(announcementItem);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            activityCallback = (AnnouncementActivity) context;
        } catch (ClassCastException e) {
            throw new ClassCastException(context.toString()
                    + " must implement AnnouncementActivity");
        }
    }

    @Override
    public void onDetach() {
        activityCallback = null;
        super.onDetach();
    }

    @Override
    public void onDestroy() {
        if (alertDialog != null) {
            if (alertDialog.isShowing()) alertDialog.cancel();
            alertDialog.setOnCancelListener(null);
            alertDialog.setOnShowListener(null);
            dialogPositiveClickListener = null;
            dialogNegativeClickListener = null;
            alertDialog = null;
        }
        if (presenter != null) {
            presenter.onDestroy();
        }

        super.onDestroy();
    }

    @Override
    public void onResume() {
        super.onResume();
        if (getActivity() != null && getActivity() instanceof AnnouncementActivity) {
            ((AnnouncementActivity) getActivity()).setLayoutHeightSecondary(false);
        }
        if (alertDialog != null && !alertDialog.isShowing() && getActivity() != null) {
            alertDialog.show();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        if(alertDialog != null && alertDialog.isShowing()) {
            alertDialog.cancel();
        }
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_dialog_version_update_announce;
    }

    @Override
    public void showOptionalUpdateAnnouncement(@Nullable String title, @Nullable String message, @Nullable String positiveOption, @Nullable String negativeOption) {
        dialogPositiveClickListener = new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                onPositiveOptionClicked();
            }
        };

        dialogNegativeClickListener = new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                onNegativeOptionClicked();
            }
        };
        if (getActivity() == null) return;

        alertDialog = new InstabugAlertDialog.Builder(getActivity())
                .setTitle(title)
                .setMessage(message)
                .setCancellable(false)
                .setPositiveButton(positiveOption, dialogPositiveClickListener)
                .setNegativeButton(negativeOption,dialogNegativeClickListener)
                .setNegativeButtonAccessibilityContentDescription("")
                .setPositiveButtonAccessibilityContentDescription("")
                .show();

    }

    @Override
    public void showMandatoryUpdateAnnouncement(@Nullable String title, @Nullable String message, @Nullable String positiveOption) {
        dialogPositiveClickListener = new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                onPositiveOptionClicked();
            }
        };
        if (getActivity() == null) return;

        alertDialog = new InstabugAlertDialog.Builder(getActivity())
                .setTitle(title)
                .setMessage(message)
                .setCancellable(false)
                .setPositiveButton(positiveOption,dialogPositiveClickListener)
                .setPositiveButtonAccessibilityContentDescription("")
                .setNegativeButtonAccessibilityContentDescription("")
                .show();
    }

    @Override
    public void onPositiveOptionClicked() {
        if (announcement == null || announcementItem == null) return;

        if (announcement.getAnnouncementItems() != null) {
            // Update the Answer for the announcement and announcement item
            for (AnnouncementItem item : announcement.getAnnouncementItems()) {
                if (item.getOptions() != null)
                    item.setAnswer(item.getOptions().get(0));
            }
        }
        if (announcementItem.getOptions() != null) {
            announcementItem.setAnswer(announcementItem.getOptions().get(0));
        }

        presenter.onPositiveOptionClicked(announcementItem, announcement);

    }

    @Override
    public void onNegativeOptionClicked() {
        if (announcement == null || announcement.getAnnouncementItems() == null || activityCallback == null)
            return;

        if (announcement.getAnnouncementItems() != null) {
            for (AnnouncementItem item : announcement.getAnnouncementItems()) {
                if (item.getOptions() != null)
                    item.setAnswer(item.getOptions().get(1));
            }
        }
        activityCallback.dismissAnnouncement(announcement);
    }

    @Override
    public void onAnnouncementItemHasConfigLink(String androidLink) {
        AnnouncementActivityCallback currentActivityCallback = activityCallback;
        if (getContext() == null || announcement == null || currentActivityCallback == null) return;
        AnnouncementNavigator.navigateToExternalBrowser(getContext(), androidLink);
        currentActivityCallback.submitAnnouncement(announcement);
    }

    @Override
    public void onAnnouncementItemDoesNotHaveConfigLink() {
        AnnouncementActivityCallback currentActivityCallback = activityCallback;
        if (getContext() != null && announcement != null && currentActivityCallback != null) {
            PlayStoreUtils.rateNow(getContext());
            currentActivityCallback.submitAnnouncement(announcement);
        }
    }
}
