package com.instabug.survey.announcements.ui.custom;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

import com.instabug.library.util.DisplayUtils;
import com.instabug.survey.common.LayoutUtils;
import com.instabug.survey.ui.ViewType;

public class DynamicRelativeLayout extends RelativeLayout {

    private boolean isMaxHeightReached;

    public DynamicRelativeLayout(Context context) {
        super(context);
    }

    public DynamicRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public DynamicRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (getContext() instanceof Activity) {
            Activity activity = (Activity) getContext();
            int maxHeight = LayoutUtils.getLayoutHeight(activity, ViewType.SECONDARY);

            if (h == maxHeight) {
                isMaxHeightReached = true;
            } else {
                // In some cases the maxHeight (assigned by Sdk) was higher than the status bar
                // so the Android framework falls back to the max height it can cover
                // which gave a false negative (h == maxHeight)
                // Here is the workaround:
                int screenHeight = DisplayUtils.getDisplayHeightInPx(activity);
                int statusBarHeight = getStatusBarHeight(activity);

                if (h == screenHeight - statusBarHeight || h == screenHeight) {
                    isMaxHeightReached = true;
                }
            }
        }
    }

    private int getStatusBarHeight(Activity activity) {
        final Resources resources = activity.getResources();
        final int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0)
            return resources.getDimensionPixelSize(resourceId);
        else
            return (int) Math.ceil((Build.VERSION.SDK_INT >= Build.VERSION_CODES.M ? 24 : 25) * resources.getDisplayMetrics().density);
    }

    public boolean isMaxHeightReached() {
        return isMaxHeightReached;
    }
}
