package com.instabug.survey.announcements.settings;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Created by Barakat on 25/12/2018
 */
public class AnnouncementsSettings {

    private int updateMsgShowInterval = -1;
    private int whatIsNewShowInterval = -1;
    private static AnnouncementsSettings instance;

    @NonNull
    public static AnnouncementsSettings getInstance() {
        if (instance == null) {
            instance = new AnnouncementsSettings();
        }
        return instance;
    }

    public void setLastFetchedAt(long time) {
        if (PersistableSettings.getInstance() != null)
            PersistableSettings.getInstance().setLastFetchedAt(time);
    }

    public long getLastFetchedAt() {
        if (PersistableSettings.getInstance() == null) return -1;

        return PersistableSettings.getInstance().getLastFetchedAt();

    }


    public int getUpdateMsgShowInterval() {
        return updateMsgShowInterval;
    }

    public void setUpdateMsgShowInterval(int updateMsgShowInterval) {
        this.updateMsgShowInterval = updateMsgShowInterval;
    }

    public int getWhatIsNewShowInterval() {
        return whatIsNewShowInterval;
    }

    public void setWhatIsNewShowInterval(int whatIsNewShowInterval) {
        this.whatIsNewShowInterval = whatIsNewShowInterval;
    }


    public static void setCountryInfo(String countryInfo) {
        if (PersistableSettings.getInstance() == null) return;
        PersistableSettings.getInstance().setCountryCode(countryInfo);
    }

    public static void setCountryInfoLastFetch(long timestamp) {
        if (PersistableSettings.getInstance() == null) return;

        PersistableSettings.getInstance().setCountryCodeLastFetch(timestamp);
    }

    @Nullable
    public static String getCountryInfo() {
        if (PersistableSettings.getInstance() == null) return null;

        return PersistableSettings.getInstance().getCountryCode();
    }

    public static long getCountyInfoLastFetch() {
        if (PersistableSettings.getInstance() == null) return -1;
        return PersistableSettings.getInstance().getCountryCodeLastFetch();
    }

    @Nullable
    public static String getLastRetrievedLocale() {
        if (PersistableSettings.getInstance() == null) return null;
        return PersistableSettings.getInstance().getAnnouncementLastRetrievedLocale();
    }

    public static void setLastRetrievedLocale(String localeCode) {
        if (PersistableSettings.getInstance() == null) return;

        PersistableSettings.getInstance().setAnnouncementLastRetrievedLocale(localeCode);
    }

}
