/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventSubscriber;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGCompositeDisposable;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.OnDiskCache;
import com.instabug.library.tokenmapping.MappedTokenChangedEventBus;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.announcements.b;
import com.instabug.survey.announcements.network.g;
import com.instabug.survey.announcements.settings.a;
import com.instabug.survey.cache.l;
import com.instabug.survey.configuration.d;
import com.instabug.survey.h;
import com.instabug.survey.models.Survey;
import com.instabug.survey.network.service.c;
import com.instabug.survey.utils.e;
import com.instabug.survey.utils.j;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Locale;

public class SurveyPlugin
extends Plugin {
    @Nullable
    IBGCompositeDisposable disposables;
    @Nullable
    private b announcementManager;
    private final d configurationsProvider = com.instabug.survey.di.a.b();
    @VisibleForTesting
    @Nullable
    IBGDisposable mappedTokenChangeDisposable;

    private void initAnnouncementSettings(Context context) {
        this.announcementManager = b.a(context);
        com.instabug.survey.announcements.settings.b.a(context);
    }

    @NonNull
    private IBGDisposable subscribeToSDKCoreEvents() {
        return IBGCoreEventSubscriber.subscribe(this::handleCoreEvents);
    }

    private void handleCoreEvents(IBGSdkCoreEvent iBGSdkCoreEvent) {
        if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.NetworkActivated) {
            this.handleNetworkActivated();
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.User) {
            this.handleUserEvent((IBGSdkCoreEvent.User)iBGSdkCoreEvent);
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.CacheDumped) {
            this.handleCacheDumped();
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.FeaturesFetched) {
            this.handleFeaturesFetched((IBGSdkCoreEvent.FeaturesFetched)iBGSdkCoreEvent);
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.Features.Fetched && j.d()) {
            this.startFetchingRequests();
        }
    }

    private void handleFeaturesFetched(IBGSdkCoreEvent.FeaturesFetched featuresFetched) {
        com.instabug.survey.di.a.a().a(featuresFetched.getResponse());
    }

    private void handleCacheDumped() {
        if (j.d()) {
            PoolProvider.postIOTask(com.instabug.survey.announcements.cache.d::a);
        }
    }

    private void handleUserEvent(IBGSdkCoreEvent.User user) {
        if (user instanceof IBGSdkCoreEvent.User.LoggedIn) {
            this.handleUserLogIn();
        } else {
            this.handleUserLogOut();
        }
    }

    private void handleUserLogOut() {
        SurveyPlugin.clearUserActivities();
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            if (h.e() != null) {
                h.e().g();
                b.a((Context)this.contextWeakReference.get()).i();
            }
            return;
        }
    }

    private void handleUserLogIn() {
        if (h.e() == null) {
            return;
        }
        h.e().h();
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            b.a((Context)this.contextWeakReference.get()).j();
            return;
        }
    }

    private void handleNetworkActivated() {
        SurveyPlugin surveyPlugin = this;
        surveyPlugin.startSubmittingPendingSurveys();
        surveyPlugin.startSubmittingPendingAnnouncements();
    }

    private IBGCompositeDisposable getOrCreateDisposables() {
        IBGCompositeDisposable iBGCompositeDisposable = this.disposables;
        if (iBGCompositeDisposable == null) {
            IBGCompositeDisposable iBGCompositeDisposable2;
            iBGCompositeDisposable = iBGCompositeDisposable2;
            iBGCompositeDisposable2 = new IBGCompositeDisposable();
            this.disposables = iBGCompositeDisposable;
        }
        return iBGCompositeDisposable;
    }

    private void subscribeOnMappedTokenChangedEvent() {
        if (this.mappedTokenChangeDisposable == null) {
            this.mappedTokenChangeDisposable = MappedTokenChangedEventBus.INSTANCE.subscribe(object -> {
                object = this.contextWeakReference;
                if (object != null && ((Reference)object).get() != null && (object = b.a((Context)this.contextWeakReference.get())) != null) {
                    ((b)object).a(true);
                }
                if ((object = h.e()) != null) {
                    ((h)object).a(true);
                }
                SurveyPlugin surveyPlugin = this;
                a.b().b(0L);
                surveyPlugin.fetchSurveysImmediately(surveyPlugin.getLocaleResolved());
                surveyPlugin.startFetchingAnnouncements(surveyPlugin.getLocaleResolved());
                surveyPlugin.resolveCountryInfo(new com.instabug.survey.models.a(), true);
            });
        }
    }

    private void startFetchingRequests() {
        PoolProvider.postIOTask(() -> {
            SurveyPlugin surveyPlugin = this;
            surveyPlugin.startFetchingSurveys(surveyPlugin.getLocaleResolved());
            surveyPlugin.startFetchingAnnouncements(surveyPlugin.getLocaleResolved());
            surveyPlugin.resolveCountryInfo(new com.instabug.survey.models.a(), false);
        });
    }

    private void startSubmittingPendingAnnouncements() {
        if (InstabugCore.getFeatureState((String)"ANNOUNCEMENTS") == Feature.State.ENABLED && ((SurveyPlugin)((Object)weakReference)).configurationsProvider.b()) {
            WeakReference weakReference = ((Plugin)weakReference).contextWeakReference;
            if (weakReference != null && (Context)weakReference.get() != null) {
                PoolProvider.postIOTask(() -> {
                    if (!com.instabug.survey.announcements.cache.c.c().isEmpty()) {
                        g.a().start();
                    }
                });
            } else {
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Couldn't submit announcements due to null context");
            }
        }
    }

    private void unSubscribeOnSDKEvents() {
        SurveyPlugin surveyPlugin = surveyPlugin.disposables;
        if (surveyPlugin != null) {
            surveyPlugin.dispose();
        }
    }

    private void unsubscribeFromMappedTokenChangedEvent() {
        IBGDisposable iBGDisposable = this.mappedTokenChangeDisposable;
        if (iBGDisposable != null) {
            iBGDisposable.dispose();
            this.mappedTokenChangeDisposable = null;
        }
    }

    private void startSubmittingPendingSurveys() {
        if (InstabugCore.getFeatureState((String)"SURVEYS") == Feature.State.ENABLED && this.configurationsProvider.c()) {
            WeakReference weakReference = this.contextWeakReference;
            if (weakReference != null && (Context)weakReference.get() != null) {
                PoolProvider.postIOTask(() -> {
                    SurveyPlugin surveyPlugin = list;
                    List list = l.a();
                    if (surveyPlugin.contextWeakReference != null && !list.isEmpty()) {
                        c.a().start();
                    }
                });
            } else {
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Couldn't submit surveys due to null context");
            }
        }
    }

    private static void clearUserActivities() {
        if (com.instabug.survey.settings.b.c() == null) {
            return;
        }
        com.instabug.survey.settings.b.c().c(0L);
        com.instabug.survey.settings.b.c().a(0L);
    }

    private void removeOldSurveys() {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!com.instabug.survey.settings.c.k() && SurveyPlugin.this.contextWeakReference != null && SurveyPlugin.this.contextWeakReference.get() != null) {
                    new OnDiskCache((Context)SurveyPlugin.this.contextWeakReference.get(), "surveys_disk_cache", "/surveys.cache", Survey.class).delete();
                    com.instabug.survey.settings.c.p();
                }
            }
        });
    }

    private void checkAppStatus() {
        Object object = ((Plugin)object).contextWeakReference;
        if (object != null && (object = (Context)((Reference)object).get()) != null) {
            e.a((Context)object);
        }
    }

    private String getLocaleResolved() {
        if (this.getAppContext() == null) {
            return "default";
        }
        return LocaleUtils.getCurrentLocaleResolved((Context)this.getAppContext());
    }

    public void init(Context context) {
        super.init(context);
    }

    public void stop() {
        SurveyPlugin surveyPlugin = this;
        com.instabug.survey.settings.b.h();
        com.instabug.survey.settings.a.m();
        surveyPlugin.unSubscribeOnSDKEvents();
        surveyPlugin.unsubscribeFromMappedTokenChangedEvent();
    }

    public void start(Context context) {
        PoolProvider.postIOTaskWithCheck(() -> {
            SurveyPlugin surveyPlugin = this;
            com.instabug.survey.settings.b.a(context);
            surveyPlugin.initAnnouncementSettings(context);
            surveyPlugin.subscribeOnMappedTokenChangedEvent();
            surveyPlugin.subscribeOnSDKEvents();
        });
    }

    public void wake() {
        this.removeOldSurveys();
        h.f();
        if (h.e() != null) {
            h.e().n();
        }
        this.checkAppStatus();
    }

    public void sleep() {
        b b2 = ((SurveyPlugin)((Object)b2)).announcementManager;
        if (b2 != null) {
            b2.k();
        }
        if (h.e() != null) {
            h.e().j();
        }
    }

    public long getLastActivityTime() {
        if (com.instabug.survey.settings.b.c() == null) {
            return -1L;
        }
        return com.instabug.survey.settings.b.c().e();
    }

    public void onLocaleChanged(Locale locale, Locale locale2) {
        SurveyPlugin surveyPlugin = object;
        super.onLocaleChanged(locale, locale2);
        com.instabug.survey.settings.c.b(0L);
        a.b().b(0L);
        if (surveyPlugin.shouldReFetch() && object.getAppContext() != null) {
            SurveyPlugin surveyPlugin2 = object;
            Object object = LocaleUtils.resolveLocale((Context)surveyPlugin2.getAppContext(), (Locale)locale2);
            surveyPlugin2.startFetchingAnnouncements((String)object);
            surveyPlugin2.fetchSurveysImmediately((String)object);
        }
    }

    public boolean isFeatureEnabled() {
        return InstabugCore.isFeatureEnabled((String)"SURVEYS");
    }

    @VisibleForTesting
    void subscribeOnSDKEvents() {
        this.getOrCreateDisposables().add(this.subscribeToSDKCoreEvents());
    }

    @VisibleForTesting
    void resolveCountryInfo(com.instabug.survey.models.a a2, boolean bl) {
        if (j.c() && (this = ((Plugin)this).contextWeakReference) != null && ((Reference)this).get() != null && h.e() != null) {
            InstabugSDKLogger.d((String)"IBG-Surveys", (String)"Getting Country Code...");
            h.e().a(a2, bl);
        }
    }

    @VisibleForTesting
    void startFetchingSurveys(String string) {
        if (InstabugCore.isAppOnForeground() && InstabugCore.isFeaturesFetchedBefore() && j.d() && ((SurveyPlugin)((Object)this)).configurationsProvider.a() && (this = ((Plugin)this).contextWeakReference) != null && ((Reference)this).get() != null && h.e() != null) {
            h.e().f(string);
        }
    }

    void fetchSurveysImmediately(String string) {
        if (InstabugCore.isAppOnForeground() && InstabugCore.isFeaturesFetchedBefore() && j.d() && ((SurveyPlugin)((Object)this)).configurationsProvider.c() && !((SurveyPlugin)((Object)this)).configurationsProvider.d() && (this = ((Plugin)this).contextWeakReference) != null && ((Reference)this).get() != null && h.e() != null) {
            h.e().a(string);
        }
    }

    @VisibleForTesting
    void startFetchingAnnouncements(String string) {
        block7: {
            if (!InstabugCore.isAppOnForeground()) break block7;
            WeakReference weakReference = this.contextWeakReference;
            if (weakReference == null) break block7;
            if (weakReference.get() == null) break block7;
            if (InstabugCore.getFeatureState((String)"ANNOUNCEMENTS") != Feature.State.ENABLED) break block7;
            if (!this.configurationsProvider.b()) break block7;
            try {
                b.a((Context)this.contextWeakReference.get()).b(string);
            }
            catch (Exception exception) {
                IBGDiagnostics.reportNonFatal((Throwable)exception, (String)("Error while fetching and processing announcements: " + exception.getMessage()));
            }
        }
    }

    @VisibleForTesting
    boolean shouldReFetch() {
        return this.getLocaleResolved().equals(com.instabug.survey.settings.c.f()) ^ true;
    }
}

