/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.cache;

import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.cache.a;
import com.instabug.survey.models.Survey;
import java.util.Iterator;
import java.util.List;

public class SurveysCacheManager {
    public static final String SURVEYS_DISK_CACHE_FILE_NAME = "/surveys.cache";
    public static final String SURVEYS_DISK_CACHE_KEY = "surveys_disk_cache";
    public static final String SURVEYS_MEMORY_CACHE_KEY = "surveys_memory_cache";

    @Nullable
    public static InMemoryCache<Long, Survey> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(SURVEYS_MEMORY_CACHE_KEY)) {
            CacheManager.KeyExtractor<Long, Survey> keyExtractor;
            InstabugSDKLogger.d(SurveysCacheManager.class, (String)"In-memory Surveys cache not found, loading it from disk ");
            CacheManager.KeyExtractor<Long, Survey> keyExtractor2 = keyExtractor;
            keyExtractor = new CacheManager.KeyExtractor<Long, Survey>(){

                public Long a(Survey survey) {
                    return survey.getId();
                }
            };
            CacheManager.getInstance().migrateCache(SURVEYS_DISK_CACHE_KEY, SURVEYS_MEMORY_CACHE_KEY, (CacheManager.KeyExtractor)keyExtractor2);
            keyExtractor2 = CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY);
            if (keyExtractor2 != null) {
                InstabugSDKLogger.d(SurveysCacheManager.class, (String)("In-memory Surveys cache restored from disk, " + keyExtractor2.size() + " elements restored"));
            }
        }
        InstabugSDKLogger.d(SurveysCacheManager.class, (String)"In-memory Surveys cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY);
    }

    public static void migrateOldCacheToDb() {
        if (SurveysCacheManager.getCache() == null) {
            return;
        }
        List list = SurveysCacheManager.getCache().getValues();
        for (Survey survey : list) {
            survey.getTarget().d().b(1);
            if (!survey.isLastEventDismiss()) continue;
            survey.setCancelled(true);
        }
        SurveysCacheManager.addSurveys(list);
        if (CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY) != null) {
            CacheManager.getInstance().deleteCache(CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY).getId());
        }
        if ((list = CacheManager.getInstance().getCache(SURVEYS_DISK_CACHE_KEY)) != null) {
            CacheManager.getInstance().deleteCache(list.getId());
            CacheManager.getInstance().invalidateCache((Cache)list);
        }
    }

    public static void addSurvey(Survey survey) {
        a.a(survey);
    }

    public static void addSurveys(List<Survey> surveys) {
        Iterator<Survey> iterator = surveys.iterator();
        while (iterator.hasNext()) {
            SurveysCacheManager.addSurvey((Survey)iterator.next());
        }
    }

    public static List<Survey> getSurveys() {
        return a.a();
    }

    public static List<Survey> getTimeTriggeredSurveys() {
        return a.e();
    }

    public static List<Survey> getEventTriggeredSurveys() {
        return a.b();
    }

    public static List<Survey> getNotAnsweredSurveys() {
        return a.c();
    }

    public static List<Survey> getReadyToSendSurveys() {
        return a.d();
    }

    public static void update(Survey survey) {
        Survey survey2;
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                a.b(survey2);
            }
        });
    }

    @WorkerThread
    public static void updateSessions(Survey survey) {
        a.c(survey);
    }

    /*
     * WARNING - void declaration
     */
    public static void insertOrUpdatePausedOrLocale(Survey survey, boolean publishStatusChanged, boolean localeChanged) {
        void var2_2;
        void var1_1;
        Survey survey2;
        PoolProvider.postIOTask((Runnable)new Runnable((boolean)var1_1, (boolean)var2_2){
            final /* synthetic */ boolean b;
            final /* synthetic */ boolean c;
            {
                this.b = bl;
                this.c = bl2;
            }

            @Override
            public void run() {
                c c2 = this;
                boolean bl = c2.b;
                a.a(survey2, bl, c2.c);
            }
        });
    }

    @Nullable
    public static Survey getSurveyById(long id) {
        return a.b(id);
    }

    public static boolean isSurveyExisting(long id) {
        return a.b(id) != null;
    }

    public static void resetSurveyUserInteraction(List<Survey> surveys) {
        List<Survey> list;
        for (Survey survey : surveys) {
            survey.resetUserInteractions();
            survey.resetUserAnswers();
        }
        SurveysCacheManager.updateBulk(list);
    }

    public static void delete(long id) {
        long l;
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                a.a(l);
            }
        });
    }

    @WorkerThread
    public static void updateBulk(List<Survey> surveys) {
        a.a(surveys);
    }
}

