package com.instabug.featuresrequest.utils;

import android.content.Context;

import com.instabug.featuresrequest.R;
import com.instabug.library.Instabug;
import com.instabug.library.util.LocaleUtils;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

/**
 * Created by mohamedzakaria on 10/1/17.
 */

public class DateUtils {
    public static String getTimeAgo(Context context, long time) {
        Date past = new Date(time);

        DateFormat df = DateFormat.getDateInstance(DateFormat.MEDIUM);

        if (!Locale.getDefault().getISO3Language().equals(Locale.ENGLISH.getISO3Language())) {
            return df.format(past);
        }

        Date now = new Date();
        long seconds = TimeUnit.MILLISECONDS.toSeconds(now.getTime() - past.getTime());
        long minutes = TimeUnit.MILLISECONDS.toMinutes(now.getTime() - past.getTime());
        long hours = TimeUnit.MILLISECONDS.toHours(now.getTime() - past.getTime());
        long days = TimeUnit.MILLISECONDS.toDays(now.getTime() - past.getTime());

        if (seconds < 60) {
            return LocaleUtils.getLocaleStringResource(Instabug.getLocale(context), R.string.feature_request_str_just_now, context);
        } else if (minutes < 60) {
            return context.getResources().getQuantityString(
                    R.plurals.instabug_feature_rq_str_minutes_ago, (int) minutes , minutes);
        } else if (hours < 24) {
            return context.getResources().getQuantityString(
                    R.plurals.instabug_feature_rq_str_hours_ago, (int) hours, hours);
        } else if (days < 7) {
            return context.getResources().getQuantityString(
                    R.plurals.instabug_feature_rq_str_days_ago, (int) days, days);
        } else {
            return df.format(past);
        }
    }
}
