package com.instabug.featuresrequest.network;

import android.annotation.SuppressLint;
import android.content.Context;

import com.instabug.featuresrequest.models.FeatureRequestResponse;
import com.instabug.featuresrequest.network.service.FeaturesRequestService;
import com.instabug.featuresrequest.utils.FeaturesRequestUtils;

import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestMethod;
import org.json.JSONArray;
import org.json.JSONException;


/**
 * Created by mohamedzakaria on 9/5/17.
 */

@SuppressLint(value = "URF_UNREAD_FIELD")
public class FeaturesRequestFetcher {

    private Callback callback;

    public FeaturesRequestFetcher(Callback callback) {
        this.callback = callback;
    }

    // todo refactor with search
    public void search(String searchKeyWord, Request.Callbacks<JSONArray,
            Throwable> callbacks) throws JSONException {
        if (FeaturesRequestUtils.isFeaturesRequestFeatureEnabled()) {
            FeaturesRequestService.getInstance().search(searchKeyWord, RequestMethod.GET, callbacks);
        }
    }

    public interface Callback {

        void onFetchingSucceeded(FeatureRequestResponse featuresRequestList);

        void onFetchingFailed(Throwable error);
    }
}
