package com.instabug.featuresrequest.utils;

import android.annotation.SuppressLint;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.TextView;

import com.instabug.library.settings.SettingsManager;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Created by mzelzoghbi on 2/19/18.
 */

public class TextViewUtils {
    private final static int MAX_CHARACTERS = 170;

    public static void makeTextViewResizable(final TextView tv,
                                             final String originalText,
                                             final String expandClickText,
                                             @NonNull final String collapseClickText,
                                             final boolean viewMore,
                                             @Nullable final Runnable runnable) {
        if (tv.getTag() == null) {
            tv.setTag(tv.getText());
        }

        if (originalText.length() < MAX_CHARACTERS) {
            tv.setText(originalText);
            return;
        }

        if (viewMore) {
            String trunclatedString = originalText.substring(0, MAX_CHARACTERS) + "... " + expandClickText;
            SpannableStringBuilder collapsedSpannable = new SpannableStringBuilder(trunclatedString);
            collapsedSpannable.setSpan(new ForegroundColorSpan(SettingsManager.getInstance().getPrimaryColor()),
                    trunclatedString.length() - expandClickText.length(),
                    trunclatedString.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);

            collapsedSpannable.setSpan(new MoreLessSpannable() {

                @SuppressLint("STARVATION")
                @Override
                public void onClick(View widget) {
                    makeTextViewResizable(tv, originalText, expandClickText, collapseClickText, !viewMore, runnable);
                    if (runnable != null)
                        runnable.run();


                }
            }, trunclatedString.length() - expandClickText.length(), trunclatedString.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            tv.setText(collapsedSpannable);

        } else {
            String expandedText = originalText + " " + collapseClickText;
            SpannableStringBuilder expandedSpannable = new SpannableStringBuilder(expandedText);

            expandedSpannable.setSpan(new ForegroundColorSpan(SettingsManager.getInstance().getPrimaryColor()),
                    expandedText.length() - collapseClickText.length(),
                    expandedText.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);

            expandedSpannable.setSpan(new MoreLessSpannable() {

                @SuppressLint("STARVATION")
                @Override
                public void onClick(View widget) {
                    makeTextViewResizable(tv, originalText, expandClickText, collapseClickText, !viewMore, runnable);
                    if (runnable != null)
                        runnable.run();
                }
            }, expandedText.length() - collapseClickText.length(), expandedText.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            tv.setText(expandedSpannable);
        }
        tv.setMovementMethod(LinkMovementMethod.getInstance());
    }

    public static class MoreLessSpannable extends ClickableSpan {

        @Override
        public void updateDrawState(TextPaint ds) {
            ds.setUnderlineText(false);
        }

        @Override
        public void onClick(View widget) {

        }
    }
}
