package com.instabug.featuresrequest.ui.base.featureslist;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.text.Html;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.listeners.OnFeatureClickListener;
import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.featuresrequest.ui.custom.IbFrRippleView;
import com.instabug.featuresrequest.utils.DateUtils;
import com.instabug.featuresrequest.utils.FormatterUtils;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.AttrResolver;

import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;

import static com.instabug.featuresrequest.utils.DrawableUtils.setColor;

/**
 * @author hossam.
 */

public class FeatureHolder implements FeaturesListContract.FeatureRowView {
    @Nullable
    private final TextView voteText;
    @Nullable
    private final ImageView voteIcon;
    @Nullable
    private final TextView title;
    @Nullable
    private final TextView tvVotesCount;
    @Nullable
    private final TextView tvCommentsCount;
    @Nullable
    private final TextView status;
    @Nullable
    private final TextView tvDate;
    @Nullable
    private final IbFrRippleView voteLayout;
    private final OnFeatureClickListener onFeatureClickListener;
    private final View view;

    FeatureHolder(View view, final OnFeatureClickListener onFeatureClickListener) {
        this.view = view;
        this.onFeatureClickListener = onFeatureClickListener;
        voteText =  view.findViewById(R.id.instabug_txt_feature_request_vote_txt);
        voteIcon =  view.findViewById(R.id.instabug_txt_feature_request_vote_icon);
        title = view.findViewById(R.id.instabug_txt_feature_request_title);
        tvVotesCount =  view.findViewById(R.id.instabug_txt_feature_request_vote_count);
        tvCommentsCount =
                 view.findViewById(R.id.instabug_txt_feature_request_comment_count);
        status =  view.findViewById(R.id.instabug_txt_feature_request_status);
        tvDate =  view.findViewById(R.id.instabug_txt_feature_request_date);
        voteLayout = view.findViewById(R.id.ib_btn_fr_vote);
    }

    @Override
    public void setFeatureTitle(String featureTitle) {
        if(title != null) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                title.setText(Html.fromHtml(featureTitle, Html.FROM_HTML_MODE_COMPACT));
            } else {
                title.setText(Html.fromHtml(featureTitle));
            }
        }
    }

    @Override
    public void setFeatureStateColor(FeatureRequest item) {
        if(status != null && voteLayout != null) {
            switch (item.getStatus()) {
                case Completed:
                    status.setText(R.string.ib_feature_rq_status_completed);
                    setFeatureStateColor(item, this, view.getContext(), R.color
                            .ib_fr_color_completed);
                    voteLayout.setEnabled(false);
                    break;
                case InProgress:
                    status.setText(R.string.ib_feature_rq_status_inprogress);
                    setFeatureStateColor(item, this, view.getContext(), R.color
                            .ib_fr_color_in_progress);
                    voteLayout.setEnabled(true);
                    break;
                case Planned:
                    status.setText(R.string.ib_feature_rq_status_planned);
                    setFeatureStateColor(item, this, view.getContext(), R.color
                            .ib_fr_color_planned);
                    voteLayout.setEnabled(true);
                    break;
                case Open:
                    status.setText(R.string.ib_feature_rq_status_open);
                    setFeatureStateColor(item, this, view.getContext(), R.color
                            .ib_fr_color_opened);
                    voteLayout.setEnabled(true);
                    break;
                case MaybeLater:
                    status.setText(R.string.ib_feature_rq_status_maybe_later);
                    setFeatureStateColor(item, this, view.getContext(), R.color
                            .ib_fr_color_maybe_later);
                    voteLayout.setEnabled(true);
                    break;
            }
        }
    }

    @Override
    public void setCommentsCount(int commentsCount) {
        if(tvCommentsCount != null) {
            tvCommentsCount.setText(FormatterUtils.formatNumber(String.valueOf(commentsCount)));
        }
    }

    @Override
    public void setVotesCount(int votesCount) {
        if(tvVotesCount != null) {
            tvVotesCount.setText(FormatterUtils.formatNumber(String.valueOf(votesCount)));
        }
    }

    @Override
    public void setCreationDate(long date) {
        if(tvDate != null) {
            tvDate.setText(DateUtils.getTimeAgo(view.getContext(), date));
        }
    }

    @Override
    public void setVoteButtonStyle(Boolean liked) {
        if(voteIcon != null && voteText != null && tvVotesCount != null) {
            voteIcon.setImageDrawable(AppCompatResources.getDrawable(view.getContext(),
                    R.drawable.ibg_fr_ic_vote_arrow));
            if (liked) {
                voteIcon.setColorFilter(ContextCompat.getColor(view.getContext(), R.color.ib_fr_white));
                setColor(voteLayout, SettingsManager.getInstance().getPrimaryColor());
                tvVotesCount.setTextColor(ContextCompat.getColor(view.getContext(), android.R.color
                        .white));
                voteText.setTextColor(ContextCompat.getColor(view.getContext(), android.R.color
                        .white));
            } else {
                setColor(voteLayout, android.R.color.white);
                if (Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                    voteIcon.setColorFilter(ContextCompat.getColor(view.getContext(),
                            R.color.ib_fr_color_ptr_loading_txt));
                    tvVotesCount.setTextColor(ContextCompat.getColor(view.getContext(), R.color
                            .ib_fr_color_ptr_loading_txt));
                    voteText.setTextColor(ContextCompat.getColor(view.getContext(), R.color
                            .ib_fr_color_ptr_loading_txt));
                } else {
                    voteIcon.setColorFilter(ContextCompat.getColor(view.getContext(),
                            R.color.ib_fr_vote_text_dark));
                    tvVotesCount.setTextColor(AttrResolver.getColor(view.getContext(), R.attr
                            .instabug_fr_text_color));
                    voteText.setTextColor(AttrResolver.getColor(view.getContext(), R.attr
                            .instabug_fr_text_color));
                }
            }
        }
    }


    @Override
    public void setVoteButtonListener(final FeatureRequest featureRequest) {
        if(voteLayout != null) {
            voteLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                @SuppressLint("STARVATION")
                public void onClick(View view) {
                    if (featureRequest.isLiked()) {
                        featureRequest.setLikesCount(featureRequest.getLikesCount() - 1);
                        featureRequest.setLiked(false);
                        setVoteButtonStyle(featureRequest.isLiked());
                        ((IbFrRippleView)view).setRippleColor(Color.parseColor("#888888"));
                        onFeatureClickListener.onUnVote(featureRequest);
                    } else {
                        featureRequest.setLiked(true);
                        featureRequest.setLikesCount(featureRequest.getLikesCount() + 1);
                        ((IbFrRippleView)view).setRippleColor(Color.parseColor("#ffffff"));
                        setVoteButtonStyle(featureRequest.isLiked());
                        onFeatureClickListener.onVote(featureRequest);
                    }
                }
            });
        }
    }


    private void setFeatureStateColor(FeatureRequest featureRequest, FeatureHolder viewHolder,
                                      Context context, @ColorRes int colorId) {
        if (featureRequest.getColorCode() != null) {
            setColor(viewHolder.status, Color.parseColor(featureRequest.getColorCode()));
        } else {
            setColor(viewHolder.status, ContextCompat.getColor(context, colorId));
        }
    }
}
