package com.instabug.featuresrequest;

import android.app.Activity;
import android.content.Intent;

import com.instabug.featuresrequest.settings.FeaturesRequestSettings;
import com.instabug.featuresrequest.ui.FeaturesRequestActivity;
import com.instabug.featuresrequest.utils.FeaturesRequestUtils;
import com.instabug.library.Feature;
import com.instabug.library.IBGFeature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;

public class FeatureRequestWrapper {
    public static void setState(Feature.State state) {
        InstabugCore.setFeatureState(IBGFeature.FEATURE_REQUESTS, state);
    }

    public static void setEmailFieldRequired(boolean isEmailFieldRequired, int... actions) {
        if (actions == null || actions.length == 0) {
            FeaturesRequestSettings.getInstance().setNewFeatureEmailFieldRequired(isEmailFieldRequired);
            FeaturesRequestSettings.getInstance().setCommenterEmailFieldRequired(isEmailFieldRequired);
        } else {
            for (int action : actions) {
                switch (action) {
                    case ActionType.REQUEST_NEW_FEATURE:
                        FeaturesRequestSettings.getInstance().setNewFeatureEmailFieldRequired(isEmailFieldRequired);
                        break;
                    case ActionType.ADD_COMMENT_TO_FEATURE:
                        FeaturesRequestSettings.getInstance().setCommenterEmailFieldRequired(isEmailFieldRequired);
                        break;
                    default:
                        break;
                }
            }
        }
    }

    public static void show() {
        if (FeaturesRequestUtils.isFeatureRequestsAvailable()
                && FeaturesRequestUtils.isFeaturesRequestFeatureEnabled()
                && Instabug.isAppOnForeground() && !InstabugCore.isForegroundBusy()) {
            Activity currentActivity = InstabugInternalTrackingDelegate.getInstance()
                    .getCurrentActivity();
            if (currentActivity != null) {
                currentActivity.startActivity(new Intent(currentActivity, FeaturesRequestActivity
                        .class));
            }
        }
    }

    public static void setUserIdentificationState(Feature.State identificationState) {
        FeaturesRequestSettings.getInstance()
                .setUserIdentificationStateEnabled(identificationState == Feature.State.ENABLED);
    }
}
