/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.ui.newfeature;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.featuresrequest.network.service.AddNewFeatureService;
import com.instabug.featuresrequest.settings.FeaturesRequestSettings;
import com.instabug.featuresrequest.ui.newfeature.AddNewFeatureContract$View;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.user.UserManagerWrapper;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;

public class AddNewFeaturePresenter
extends BasePresenter<AddNewFeatureContract$View>
implements BaseContract.Presenter {
    @Nullable
    private final AddNewFeatureContract$View viewInstance;
    @Nullable
    private volatile String enteredEmail;
    private final FeaturesRequestSettings settings;

    public AddNewFeaturePresenter(AddNewFeatureContract$View object) {
        AddNewFeaturePresenter addNewFeaturePresenter = this;
        super((BaseContract.View)object);
        addNewFeaturePresenter.enteredEmail = null;
        object = FeaturesRequestSettings.getInstance();
        addNewFeaturePresenter.settings = object;
        addNewFeaturePresenter.viewInstance = (AddNewFeatureContract$View)addNewFeaturePresenter.view.get();
        if (((FeaturesRequestSettings)object).isUserIdentificationStateEnabled()) {
            this.fillUserDataViews();
        } else {
            this.hideUserDataViews();
        }
    }

    private void fillUserDataViews() {
        PoolProvider.postIOTask(() -> {
            AddNewFeaturePresenter addNewFeaturePresenter = object;
            Object object = InstabugCore.getEnteredEmail();
            addNewFeaturePresenter.enteredEmail = object;
            PoolProvider.postMainThreadTask(() -> addNewFeaturePresenter.lambda$fillUserDataViews$0((String)object, addNewFeaturePresenter.getEnteredUsername()));
        });
    }

    private void hideUserDataViews() {
        AddNewFeatureContract$View addNewFeatureContract$View = this.viewInstance;
        if (addNewFeatureContract$View != null) {
            addNewFeatureContract$View.hideUserEmail();
            this.viewInstance.hideUserName();
        }
    }

    private boolean isEmailVerificationRequired() {
        return ((AddNewFeaturePresenter)((Object)this)).settings.isNewFeatureEmailFieldRequired() || (this = ((AddNewFeaturePresenter)((Object)this)).viewInstance) != null && !this.getEmailString().isEmpty();
    }

    private void addFeature() {
        if (this.viewInstance != null) {
            Request.Callbacks<Boolean, Throwable> callbacks;
            FeatureRequest featureRequest;
            if (this.settings.isUserIdentificationStateEnabled()) {
                AddNewFeaturePresenter addNewFeaturePresenter = this;
                InstabugCore.setEnteredEmail((String)addNewFeaturePresenter.viewInstance.getEmailString());
                InstabugCore.setEnteredUsername((String)addNewFeaturePresenter.viewInstance.getNameString());
            }
            AddNewFeaturePresenter addNewFeaturePresenter = this;
            addNewFeaturePresenter.viewInstance.showProgressbarDialog();
            final FeatureRequest featureRequest2 = featureRequest;
            AddNewFeaturePresenter addNewFeaturePresenter2 = this;
            Object object = addNewFeaturePresenter2.getUserName();
            String string2 = addNewFeaturePresenter2.getUserEmail();
            featureRequest = new FeatureRequest((String)object, string2, InstabugCore.getPushNotificationToken());
            object = addNewFeaturePresenter.viewInstance.getFeatureTitle() != null ? this.viewInstance.getFeatureTitle() : "";
            featureRequest2.setTitle((String)object);
            featureRequest2.setDescription(this.viewInstance.getFeatureDescription());
            if (Instabug.getApplicationContext() == null) {
                return;
            }
            object = callbacks;
            callbacks = new Request.Callbacks<Boolean, Throwable>(){

                private void notifySyncFailed() {
                    PoolProvider.postMainThreadTask(() -> {
                        if (AddNewFeaturePresenter.this.viewInstance == null) {
                            return;
                        }
                        1 v0 = this;
                        v0.AddNewFeaturePresenter.this.viewInstance.hideProgressbarDialog();
                        v0.AddNewFeaturePresenter.this.viewInstance.showCustomToast(R.string.feature_request_str_add_comment_error);
                    });
                }

                public void onSucceeded(@Nullable Boolean bl) {
                    InstabugSDKLogger.d((String)"IBG-FR", (String)"featureRequest synced successfully");
                    PoolProvider.postMainThreadTask((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (AddNewFeaturePresenter.this.viewInstance == null) {
                                return;
                            }
                            1 v0 = this;
                            v0.AddNewFeaturePresenter.this.viewInstance.hideProgressbarDialog();
                            v0.AddNewFeaturePresenter.this.viewInstance.navigateToThanksScreen();
                        }
                    });
                }

                public void onFailed(Throwable throwable) {
                    InstabugSDKLogger.e((String)"IBG-FR", (String)("Something went wrong while sending featureRequest: " + featureRequest2), (Throwable)throwable);
                    this.notifySyncFailed();
                }

                public void onDisconnected() {
                    InstabugSDKLogger.e((String)"IBG-FR", (String)("Something went wrong while sending featureRequest: " + featureRequest2 + " Device is offline"));
                    this.notifySyncFailed();
                }
            };
            AddNewFeatureService.getInstance().sendNewFeature(featureRequest2, (Request.Callbacks<Boolean, Throwable>)object);
        }
    }

    @NonNull
    private String getUserEmail() {
        return this.settings.isUserIdentificationStateEnabled() ? UserManagerWrapper.getUserEmail() : "";
    }

    @Nullable
    private String getUserName() {
        return this.settings.isUserIdentificationStateEnabled() ? UserManagerWrapper.getUserName() : "";
    }

    private /* synthetic */ void lambda$fillUserDataViews$0(String string2, String string3) {
        AddNewFeatureContract$View addNewFeatureContract$View = this.viewInstance;
        if (addNewFeatureContract$View != null) {
            if (string2 != null) {
                addNewFeatureContract$View.setUserEmail(string2);
            }
            if (string3 != null) {
                this.viewInstance.setUserName(string3);
            }
        }
    }

    public void onAddButtonClicked() {
        AddNewFeatureContract$View addNewFeatureContract$View = this.viewInstance;
        if (addNewFeatureContract$View == null) {
            return;
        }
        if (addNewFeatureContract$View.getFeatureTitle() == null) {
            return;
        }
        if (this.settings.isUserIdentificationStateEnabled() && this.isEmailVerificationRequired()) {
            if (this.viewInstance.getValidEmail() != null) {
                this.addFeature();
            }
        } else {
            this.addFeature();
        }
    }

    @Nullable
    public String getEnteredEmail() {
        return this.enteredEmail != null ? this.enteredEmail : InstabugCore.getEnteredEmail();
    }

    @Nullable
    public String getEnteredUsername() {
        return InstabugCore.getEnteredUsername();
    }

    public void handelRequiredFieldsHints() {
        AddNewFeatureContract$View addNewFeatureContract$View = ((AddNewFeaturePresenter)((Object)addNewFeatureContract$View)).viewInstance;
        if (addNewFeatureContract$View != null) {
            addNewFeatureContract$View.setEmailHintStringWithAsterisk(FeaturesRequestSettings.getInstance().isNewFeatureEmailFieldRequired());
        }
    }
}

