/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.ui.custom;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import com.instabug.featuresrequest.R;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class IbFrRippleView
extends LinearLayout {
    private final Runnable runnable;
    private int WIDTH;
    private int HEIGHT;
    private int frameRate;
    private int rippleDuration;
    private int rippleAlpha;
    private Handler canvasHandler;
    private float radiusMax;
    private boolean animationRunning;
    private int timer;
    private int timerEmpty;
    private int durationEmpty;
    private float x;
    private float y;
    private int zoomDuration;
    private float zoomScale;
    private ScaleAnimation scaleAnimation;
    private Boolean hasToZoom;
    private Boolean isCentered;
    private Integer rippleType;
    private Paint paint;
    private Bitmap originBitmap;
    private int rippleColor;
    private int ripplePadding;
    private GestureDetector gestureDetector;

    public IbFrRippleView(Context context) {
        IbFrRippleView ibFrRippleView = this;
        super(context);
        ibFrRippleView.runnable = () -> this.invalidate();
        ibFrRippleView.frameRate = 10;
        ibFrRippleView.rippleDuration = 200;
        ibFrRippleView.rippleAlpha = 90;
        ibFrRippleView.radiusMax = 0.0f;
        ibFrRippleView.animationRunning = false;
        ibFrRippleView.timer = 0;
        ibFrRippleView.timerEmpty = 0;
        ibFrRippleView.durationEmpty = -1;
        ibFrRippleView.x = -1.0f;
        ibFrRippleView.y = -1.0f;
        ibFrRippleView.zoomDuration = 200;
        ibFrRippleView.rippleType = 2;
    }

    public IbFrRippleView(Context context, AttributeSet attributeSet) {
        IbFrRippleView ibFrRippleView = this;
        super(context, attributeSet);
        ibFrRippleView.runnable = () -> this.invalidate();
        ibFrRippleView.frameRate = 10;
        ibFrRippleView.rippleDuration = 200;
        ibFrRippleView.rippleAlpha = 90;
        ibFrRippleView.radiusMax = 0.0f;
        ibFrRippleView.animationRunning = false;
        ibFrRippleView.timer = 0;
        ibFrRippleView.timerEmpty = 0;
        ibFrRippleView.durationEmpty = -1;
        ibFrRippleView.x = -1.0f;
        ibFrRippleView.y = -1.0f;
        ibFrRippleView.zoomDuration = 200;
        ibFrRippleView.rippleType = 2;
        this.init(context, attributeSet);
    }

    public IbFrRippleView(Context context, AttributeSet attributeSet, int n) {
        IbFrRippleView ibFrRippleView = this;
        super(context, attributeSet, n);
        ibFrRippleView.runnable = () -> this.invalidate();
        ibFrRippleView.frameRate = 10;
        ibFrRippleView.rippleDuration = 200;
        ibFrRippleView.rippleAlpha = 90;
        ibFrRippleView.radiusMax = 0.0f;
        ibFrRippleView.animationRunning = false;
        ibFrRippleView.timer = 0;
        ibFrRippleView.timerEmpty = 0;
        ibFrRippleView.durationEmpty = -1;
        ibFrRippleView.x = -1.0f;
        ibFrRippleView.y = -1.0f;
        ibFrRippleView.zoomDuration = 200;
        ibFrRippleView.rippleType = 2;
        this.init(context, attributeSet);
    }

    private void init(Context context, AttributeSet attributeSet) {
        GestureDetector gestureDetector;
        Paint paint;
        Handler handler;
        if (this.isInEditMode()) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.IbFrRippleView);
        this.rippleColor = typedArray.getColor(R.styleable.IbFrRippleView_ib_fr_rv_color, this.getResources().getColor(R.color.ib_fr_ripple_color));
        this.rippleType = typedArray.getInt(R.styleable.IbFrRippleView_ib_fr_rv_type, 2);
        this.hasToZoom = typedArray.getBoolean(R.styleable.IbFrRippleView_ib_fr_rv_zoom, true);
        this.isCentered = typedArray.getBoolean(R.styleable.IbFrRippleView_ib_fr_rv_centered, true);
        this.rippleDuration = typedArray.getInteger(R.styleable.IbFrRippleView_ib_fr_rv_rippleDuration, 200);
        this.frameRate = typedArray.getInteger(R.styleable.IbFrRippleView_ib_fr_rv_framerate, this.frameRate);
        this.rippleAlpha = typedArray.getInteger(R.styleable.IbFrRippleView_ib_fr_rv_alpha, this.rippleAlpha);
        this.ripplePadding = typedArray.getDimensionPixelSize(R.styleable.IbFrRippleView_ib_fr_rv_ripplePadding, 0);
        attributeSet = handler;
        handler = new Handler();
        this.canvasHandler = attributeSet;
        this.zoomScale = typedArray.getFloat(R.styleable.IbFrRippleView_ib_fr_rv_zoomScale, 1.03f);
        this.zoomDuration = typedArray.getInt(R.styleable.IbFrRippleView_ib_fr_rv_zoomDuration, 200);
        typedArray.recycle();
        attributeSet = paint;
        this.paint = attributeSet;
        new Paint().setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.rippleColor);
        this.paint.setAlpha(this.rippleAlpha);
        this.setWillNotDraw(false);
        attributeSet = gestureDetector;
        gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent motionEvent) {
                1 v0 = this;
                super.onLongPress(motionEvent);
                v0.IbFrRippleView.this.animateRipple(motionEvent);
                v0.IbFrRippleView.this.sendClickEvent(Boolean.TRUE);
            }

            public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
                return true;
            }

            public boolean onSingleTapUp(MotionEvent motionEvent) {
                return true;
            }
        });
        this.gestureDetector = attributeSet;
        this.setDrawingCacheEnabled(true);
        this.setClickable(true);
    }

    private void createAnimation(float f, float f2) {
        if (this.isEnabled() && !this.animationRunning) {
            if (this.hasToZoom.booleanValue()) {
                this.startAnimation((Animation)this.scaleAnimation);
            }
            this.radiusMax = Math.max(this.WIDTH, this.HEIGHT);
            if (this.rippleType != 2) {
                this.radiusMax /= 2.0f;
            }
            this.radiusMax -= (float)this.ripplePadding;
            if (!this.isCentered.booleanValue() && this.rippleType != 1) {
                this.x = f;
                this.y = f2;
            } else {
                this.x = (float)this.getMeasuredWidth() / 2.0f;
                this.y = (float)this.getMeasuredHeight() / 2.0f;
            }
            this.animationRunning = true;
            if (this.rippleType == 1 && this.originBitmap == null) {
                this.originBitmap = this.getDrawingCache(true);
            }
            this.invalidate();
        }
    }

    private void sendClickEvent(Boolean bl) {
        if (this.getParent() instanceof AdapterView) {
            Boolean bl2 = bl;
            bl = (AdapterView)this.getParent();
            int n = bl.getPositionForView((View)this);
            long l = bl.getItemIdAtPosition(n);
            if (bl2.booleanValue()) {
                if (bl.getOnItemLongClickListener() != null) {
                    bl.getOnItemLongClickListener().onItemLongClick((AdapterView)bl, (View)this, n, l);
                }
            } else if (bl.getOnItemClickListener() != null) {
                bl.getOnItemClickListener().onItemClick((AdapterView)bl, (View)this, n, l);
            }
        }
    }

    private Bitmap getCircleBitmap(int n) {
        Rect rect;
        Paint paint;
        Canvas canvas;
        Bitmap bitmap = Bitmap.createBitmap((int)this.originBitmap.getWidth(), (int)this.originBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Bitmap bitmap2 = bitmap;
        Canvas canvas2 = canvas;
        canvas2(bitmap2);
        bitmap2 = paint;
        Canvas canvas3 = canvas2;
        IbFrRippleView ibFrRippleView = this;
        Canvas canvas4 = canvas2;
        Bitmap bitmap3 = bitmap2;
        bitmap3();
        canvas2 = rect;
        IbFrRippleView ibFrRippleView2 = this;
        float f = ibFrRippleView2.x;
        float f2 = n;
        int n2 = (int)(f - f2);
        float f3 = ibFrRippleView2.y;
        int n3 = n2;
        int n4 = (int)(f3 - f2);
        n2 = (int)(f + f2);
        int n5 = (int)(f3 + f2);
        rect = new Rect(n3, n4, n2, n5);
        bitmap3.setAntiAlias(true);
        canvas4.drawARGB(0, 0, 0, 0);
        float f4 = ibFrRippleView.x;
        canvas3.drawCircle(f4, ibFrRippleView.y, f2, (Paint)bitmap2);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        Canvas canvas5 = canvas2;
        canvas.drawBitmap(this.originBitmap, (Rect)canvas5, (Rect)canvas5, (Paint)bitmap2);
        return bitmap;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.animationRunning) {
            canvas.save();
            int n = this.frameRate;
            if (this.rippleDuration <= this.timer * n) {
                this.animationRunning = false;
                this.timer = 0;
                this.durationEmpty = -1;
                this.timerEmpty = 0;
                if (Build.VERSION.SDK_INT != 23) {
                    canvas.restore();
                }
                this.invalidate();
                return;
            }
            Runnable runnable = this.runnable;
            long l = n;
            this.canvasHandler.postDelayed(runnable, l);
            if (this.timer == 0) {
                canvas.save();
            }
            canvas.drawCircle(this.x, this.y, this.radiusMax * ((float)this.timer * (float)this.frameRate / (float)this.rippleDuration), this.paint);
            this.paint.setColor(Color.parseColor((String)"#ffff4444"));
            if (this.rippleType == 1 && this.originBitmap != null) {
                int n2;
                int n3;
                int n4;
                int n5 = this.timer;
                int n6 = this.frameRate;
                int n7 = this.rippleDuration;
                if ((float)n4 * (float)n3 / (float)n2 > 0.4f) {
                    if (this.durationEmpty == -1) {
                        this.durationEmpty = n7 - n5 * n6;
                    }
                    this.timerEmpty = n5 = this.timerEmpty + 1;
                    Bitmap bitmap = this.getCircleBitmap((int)(this.radiusMax * ((float)n5 * (float)n6 / (float)this.durationEmpty)));
                    canvas = this.paint;
                    canvas.drawBitmap(bitmap, 0.0f, 0.0f, (Paint)canvas);
                    bitmap.recycle();
                }
            }
            this.paint.setColor(this.rippleColor);
            if (this.rippleType == 1) {
                int n8;
                int n9 = this.frameRate;
                if ((float)this.timer * (float)n8 / (float)this.rippleDuration > 0.6f) {
                    int n10 = this.rippleAlpha;
                    this.paint.setAlpha((int)((float)n10 - (float)n10 * ((float)this.timerEmpty * (float)n9 / (float)this.durationEmpty)));
                } else {
                    this.paint.setAlpha(this.rippleAlpha);
                }
            } else {
                int n11 = this.rippleAlpha;
                this.paint.setAlpha((int)((float)n11 - (float)n11 * ((float)this.timer * (float)this.frameRate / (float)this.rippleDuration)));
            }
            ++this.timer;
        }
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        ScaleAnimation scaleAnimation;
        ScaleAnimation scaleAnimation2;
        IbFrRippleView ibFrRippleView = this;
        super.onSizeChanged(n, n2, n3, n4);
        this.WIDTH = n;
        ibFrRippleView.HEIGHT = n2;
        ScaleAnimation scaleAnimation3 = scaleAnimation2 = scaleAnimation;
        float f = this.zoomScale;
        float f2 = (float)n / 2.0f;
        float f3 = (float)n2 / 2.0f;
        scaleAnimation3(1.0f, f, 1.0f, f, f2, f3);
        this.scaleAnimation = scaleAnimation3;
        scaleAnimation.setDuration((long)this.zoomDuration);
        ibFrRippleView.scaleAnimation.setRepeatMode(2);
        ibFrRippleView.scaleAnimation.setRepeatCount(1);
    }

    public void animateRipple(MotionEvent motionEvent) {
        MotionEvent motionEvent2 = motionEvent;
        float f = motionEvent2.getX();
        this.createAnimation(f, motionEvent2.getY());
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.gestureDetector.onTouchEvent(motionEvent)) {
            IbFrRippleView ibFrRippleView = this;
            ibFrRippleView.animateRipple(motionEvent);
            ibFrRippleView.sendClickEvent(Boolean.FALSE);
        }
        return super.onTouchEvent(motionEvent);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        this.onTouchEvent(motionEvent);
        return super.onInterceptTouchEvent(motionEvent);
    }

    public int getRippleColor() {
        return this.rippleColor;
    }

    public void setRippleColor(int n) {
        this.rippleColor = n;
    }

    public RippleType getRippleType() {
        return RippleType.values()[this.rippleType];
    }

    public void setRippleType(RippleType rippleType) {
        this.rippleType = rippleType.ordinal();
    }

    public void setCentered(Boolean bl) {
        this.isCentered = bl;
    }

    public int getRipplePadding() {
        return this.ripplePadding;
    }

    public void setRipplePadding(int n) {
        this.ripplePadding = n;
    }

    public void setZooming(Boolean bl) {
        this.hasToZoom = bl;
    }

    public float getZoomScale() {
        return this.zoomScale;
    }

    public void setZoomScale(float f) {
        this.zoomScale = f;
    }

    public int getZoomDuration() {
        return this.zoomDuration;
    }

    public void setZoomDuration(int n) {
        this.zoomDuration = n;
    }

    public int getRippleDuration() {
        return this.rippleDuration;
    }

    public void setRippleDuration(int n) {
        this.rippleDuration = n;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int n) {
        this.frameRate = n;
    }

    public int getRippleAlpha() {
        return this.rippleAlpha;
    }

    public void setRippleAlpha(int n) {
        this.rippleAlpha = n;
    }

    public void setOnRippleCompleteListener(OnRippleCompleteListener onRippleCompleteListener) {
    }

    public static interface OnRippleCompleteListener {
    }

    public static enum RippleType {
        SIMPLE(0),
        DOUBLE(1),
        RECTANGLE(2);

        int type;

        private RippleType(int n2) {
            this.type = n2;
        }
    }
}

