/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.network.service;

import androidx.annotation.NonNull;
import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import org.json.JSONException;

public class AddNewFeatureService {
    private static volatile AddNewFeatureService addNewFeatureServiceInstance;
    private NetworkManager networkManager;

    private AddNewFeatureService() {
        if (addNewFeatureServiceInstance == null) {
            NetworkManager networkManager;
            AddNewFeatureService addNewFeatureService = addNewFeatureService2;
            AddNewFeatureService addNewFeatureService2 = networkManager;
            networkManager = new NetworkManager();
            addNewFeatureService.networkManager = addNewFeatureService2;
            return;
        }
        throw new RuntimeException("Use getInstance() method to get the single instance of this class");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AddNewFeatureService getInstance() {
        if (addNewFeatureServiceInstance != null) return addNewFeatureServiceInstance;
        Class<AddNewFeatureService> clazz = AddNewFeatureService.class;
        synchronized (AddNewFeatureService.class) {
            try {
                if (addNewFeatureServiceInstance != null) return addNewFeatureServiceInstance;
                addNewFeatureServiceInstance = new AddNewFeatureService();
                // ** MonitorExit[var0] (shouldn't be in output)
                return addNewFeatureServiceInstance;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    private Request createSendFeatureRequest(@NonNull FeatureRequest object) {
        AddNewFeatureService addNewFeatureService = new Request.Builder().endpoint("/feature_reqs").method("POST").addParameter(new RequestParameter("push_token", (Object)((FeatureRequest)object).getDeviceToken())).addParameter(new RequestParameter("feature_request", (Object)((FeatureRequest)object).getFeatureJsonObject()));
        String string2 = ((FeatureRequest)object).getRequesterEmail();
        if (string2 != null && !string2.trim().isEmpty()) {
            RequestParameter requestParameter;
            RequestParameter requestParameter2 = requestParameter;
            requestParameter = new RequestParameter("email", (Object)string2);
            addNewFeatureService.addParameter(requestParameter2);
        }
        if ((object = ((FeatureRequest)object).getRequesterName()) != null && !((String)object).trim().isEmpty()) {
            RequestParameter requestParameter;
            string2 = requestParameter;
            requestParameter = new RequestParameter("name", object);
            addNewFeatureService.addParameter((RequestParameter)string2);
        }
        return addNewFeatureService.build();
    }

    private Request.Callbacks<RequestResponse, Throwable> createRequestCallback(final Request.Callbacks<Boolean, Throwable> callbacks) {
        return new Request.Callbacks<RequestResponse, Throwable>(){

            public void onSucceeded(RequestResponse requestResponse) {
                InstabugSDKLogger.d((String)"IBG-FR", (String)("sendFeatureRequest request Succeeded, Response code: " + requestResponse.getResponseCode()));
                InstabugSDKLogger.v((String)"IBG-FR", (String)("Sending feature request Response body: " + requestResponse.getResponseBody()));
                if (requestResponse.getResponseCode() == 200 && requestResponse.getResponseBody() != null) {
                    callbacks.onSucceeded((Object)Boolean.TRUE);
                } else {
                    callbacks.onSucceeded((Object)Boolean.FALSE);
                }
            }

            public void onFailed(Throwable throwable) {
                InstabugSDKLogger.e((String)"IBG-FR", (String)"sendFeatureRequest request got error: ", (Throwable)throwable);
                callbacks.onFailed((Object)throwable);
            }

            public void onDisconnected() {
                callbacks.onDisconnected();
            }
        };
    }

    public void sendNewFeature(FeatureRequest featureRequest, Request.Callbacks<Boolean, Throwable> callbacks) {
        InstabugSDKLogger.d((String)"IBG-FR", (String)"Sending new feature");
        PoolProvider.postIOTask(() -> {
            AddNewFeatureService addNewFeatureService = addNewFeatureService4;
            AddNewFeatureService addNewFeatureService2 = addNewFeatureService;
            AddNewFeatureService addNewFeatureService3 = addNewFeatureService;
            Request.Callbacks callbacks3 = callbacks;
            AddNewFeatureService addNewFeatureService4 = addNewFeatureService4.createSendFeatureRequest(featureRequest);
            featureRequest = addNewFeatureService2.createRequestCallback((Request.Callbacks<Boolean, Throwable>)callbacks3);
            try {
                addNewFeatureService3.networkManager.doRequest("FEATURES_REQUEST", 1, (Request)addNewFeatureService4, featureRequest);
            }
            catch (JSONException jSONException) {
                callbacks.onFailed((Object)jSONException);
            }
        });
    }
}

