package com.instabug.featuresrequest.models;

import android.annotation.SuppressLint;

import androidx.annotation.NonNull;

import com.instabug.library.util.InstabugSDKLogger;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by mzelzoghbi on 3/5/18.
 */
// no place for error here
@SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
public class Comment extends TimelineObject {

    public static final String KEY_ID = "id";
    public static final String KEY_BODY = "body";
    public static final String KEY_ADMIN = "admin";
    public static final String KEY_COMMENTER_NAME = "commenter_name";
    public static final String KEY_AVATAR = "avatar";
    public static final String KEY_UUID = "uuid";

    protected long id;
    private String body;
    private boolean admin;
    private String commenterName;
    private String avatar;
    private String uuid;



    // internal use for list
    private boolean lastViewmoreState = true;
    private String avatarFilePath;

    public String getAvatarFilePath() {
        return avatarFilePath;
    }

    public void setAvatarFilePath(String avatarFilePath) {
        this.avatarFilePath = avatarFilePath;
    }

    public boolean isLastViewmoreState() {
        return lastViewmoreState;
    }

    public void setLastViewmoreState(boolean lastViewmoreState) {
        this.lastViewmoreState = lastViewmoreState;
    }

    public long getId() {
        return id;
    }

    public void setCommentId(long id) {
        this.id = id;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean isAdmin() {
        return admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public String getCommenterName() {
        return commenterName;
    }

    public void setCommenterName(String commenterName) {
        this.commenterName = commenterName;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject
                .put(KEY_ID, getId())
                .put(KEY_CREATED_AT, getCreatedAt())
                .put(KEY_TYPE, getType());

        jsonObject.put(KEY_UUID, getUuid());
        jsonObject.put(KEY_BODY, getBody());
        jsonObject.put(KEY_ADMIN, isAdmin());
        jsonObject.put(KEY_COMMENTER_NAME, getCommenterName());
        jsonObject.put(KEY_AVATAR, getAvatar());
        return jsonObject.toString();
    }

    @Override
    public void fromJson(String modelAsJson) throws JSONException {

        JSONObject commentJsonObject = new JSONObject(modelAsJson);

        if (commentJsonObject.has(KEY_ID)) {
            setCommentId(commentJsonObject.getLong(KEY_ID));
        }

        if (commentJsonObject.has(KEY_CREATED_AT)) {
            setCreatedAt(commentJsonObject.getLong(KEY_CREATED_AT));
        }

        if (commentJsonObject.has(KEY_TYPE)) {
            String status = commentJsonObject.getString(KEY_TYPE);
            switch (status) {
                default:
                case "comment":
                    setType(Type.COMMENT);
                    break;
                case "state_change":
                    setType(Type.STATUS_CHANE);
                    break;

            }
        }

        if (commentJsonObject.has(KEY_UUID)) {
            setUuid(commentJsonObject.getString(KEY_UUID));
        }

        if (commentJsonObject.has(KEY_BODY)) {
            setBody(commentJsonObject.getString(KEY_BODY));
        }

        if (commentJsonObject.has(KEY_ADMIN)) {
            setAdmin(commentJsonObject.getBoolean(KEY_ADMIN));
        }

        if (commentJsonObject.has(KEY_COMMENTER_NAME)) {
            setCommenterName(commentJsonObject.getString(KEY_COMMENTER_NAME));
        }

        if (commentJsonObject.has(KEY_AVATAR)) {
            setAvatar(commentJsonObject.getString(KEY_AVATAR));
        }
    }


}
