package com.instabug.featuresrequest.settings;

import android.annotation.SuppressLint;

import androidx.annotation.VisibleForTesting;

import com.instabug.library.IBGFeature;
import com.instabug.library.core.InstabugCore;


/**
 * Created by mohamedzakaria on 9/5/17.
 */

public class FeaturesRequestSettings {
    public static final String CURRENT_VERSION = "1";

    private static FeaturesRequestSettings featuresRequestSettingsInstance;

    private FeaturesRequestSettings() {
    }

    /**
     * Returns the current singleton instance of this class.
     *
     * @return a {@code SettingsManager} instance
     */
    public static FeaturesRequestSettings getInstance() {
        if (featuresRequestSettingsInstance == null) {
            featuresRequestSettingsInstance = new FeaturesRequestSettings();
        }
        return featuresRequestSettingsInstance;
    }

    @VisibleForTesting
    @SuppressLint("ERADICATE_FIELD_NOT_NULLABLE")
    static void tearDown() {
        featuresRequestSettingsInstance = null;
    }

    public void setNewFeatureEmailFieldRequired(boolean isRequired) {
        PerSessionSettings.getInstance().setNewFeatureEmailFieldRequired(isRequired);
    }

    public boolean isNewFeatureEmailFieldRequired() {
        return PerSessionSettings.getInstance().isNewFeatureEmailFieldRequired();
    }

    public void setCommenterEmailFieldRequired(boolean isRequired) {
        PerSessionSettings.getInstance().setCommenterEmailFieldRequired(isRequired);
    }

    public boolean isCommenterEmailFieldRequired() {
        return PerSessionSettings.getInstance().isCommenterEmailFieldRequired();
    }

    public static void setLastSortByAction(int action) {
        if (PersistableSettings.getInstance() == null) return;

        PersistableSettings.getInstance().setLastSortByAction(action);
    }

    public static int getLastSortByAction() {
        if (PersistableSettings.getInstance() == null) return 0;
        return PersistableSettings.getInstance().getLastSortByAction();
    }

    public static boolean shouldSortByTopRated() {
        if (PersistableSettings.getInstance() == null) return true;
        return PersistableSettings.getInstance().getLastSortByAction() == 0;
    }

    public long getLastActivityTime() {
        if (PersistableSettings.getInstance() == null) return 0;
        return PersistableSettings.getInstance().getLastActivityTime();
    }

    public void setLastActivityTime(long time) {
        if (PersistableSettings.getInstance() == null) return;
        PersistableSettings.getInstance().setLastActivityTime(time);
    }

    public boolean isFeatureEnabled() {
        boolean featureAvailable = InstabugCore.isFeatureAvailable(IBGFeature.FEATURE_REQUESTS);
        boolean experimentalFeatureAvailable = InstabugCore.isExperimentalFeatureAvailable(IBGFeature.FEATURE_REQUESTS);
        boolean featureEnabled = InstabugCore.isFeatureEnabled(IBGFeature.FEATURE_REQUESTS);
        return featureAvailable && experimentalFeatureAvailable && featureEnabled;
    }

    public boolean isUserIdentificationStateEnabled() {
        return PerSessionSettings.getInstance().isUserIdentificationStateEnabled();
    }

    public void setUserIdentificationStateEnabled(boolean userIdentificationStateEnabled) {
        PerSessionSettings.getInstance().setUserIdentificationStateEnabled(userIdentificationStateEnabled);
    }
}
