package com.instabug.featuresrequest.ui.newfeature;

import static com.instabug.featuresrequest.ui.custom.ToolbarActionButton.ViewType.ICON;
import static com.instabug.featuresrequest.ui.custom.ToolbarActionButton.ViewType.TEXT;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.util.Patterns;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;

import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.settings.FeaturesRequestSettings;
import com.instabug.featuresrequest.ui.FeaturesRequestActivity;
import com.instabug.featuresrequest.ui.custom.DynamicToolbarFragment;
import com.instabug.featuresrequest.ui.custom.InstaToast;
import com.instabug.featuresrequest.ui.custom.ToolbarActionButton;
import com.instabug.featuresrequest.utils.TextInputLayoutHelper;
import com.instabug.featuresrequest.utils.ViewUtilsKt;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.ui.custom.InstabugAlertDialog;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.KeyboardUtils;
import com.instabug.library.util.LocaleHelper;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.SimpleTextWatcher;
import com.instabug.library.view.ViewUtils;

/**
 * @author hossam.
 */

// no place for error here
@SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
public class AddNewFeatureFragment extends DynamicToolbarFragment<AddNewFeaturePresenter> implements
        AddNewFeatureContract.View, View.OnClickListener {

    @Nullable
    private TextInputLayout titleInputLayout;
    @Nullable
    private TextInputLayout descriptionInputLayout;
    @Nullable
    private TextInputLayout nameInputLayout;
    @Nullable
    private TextInputLayout emailInputLayout;

    @Nullable
    private TextInputEditText titleEditTextLayout;
    @Nullable
    private TextInputEditText descriptionEditTextLayout;
    @Nullable
    private TextInputEditText nameEditTextLayout;
    @Nullable
    private TextInputEditText emailEditTextLayout;

    @Nullable
    private View underLineTitle;
    @Nullable
    private View underLineDescription;
    @Nullable
    private View underLineName;
    @Nullable
    private View underLineEmail;

    @Nullable
    private RelativeLayout relativeLayoutNewFeature;

    @Nullable
    private TextView emailDisclaimer;
    @Nullable
    private TextView toolbarAddTextView;

    @Override
    public void onClick(View v) {

    }

    @Override
    public void navigateToThanksScreen() {
        if (getActivity() != null) {
            ((FeaturesRequestActivity) getActivity()).showThanksDialog();
        }
    }

    @Override
    public void showCustomToast(String message) {

    }

    @Override
    public void showCustomToast(@StringRes int resId) {

    }

    @Override
    public void showProgressbarDialog() {
        if (getActivity() != null) {
            ((FeaturesRequestActivity) getActivity()).showProgressDialog();
        }
    }

    @Override
    public void hideProgressbarDialog() {
        if (getActivity() != null) {
            ((FeaturesRequestActivity) getActivity()).hideProgressDialog();
        }
    }

    @Override
    public void showExitDialog() {
        Activity currentActivity = getActivity();
        if (currentActivity != null)
            new InstabugAlertDialog.Builder(currentActivity).setMessage(getLocalizedString(R.string.feature_request_close_dialog_message))
                    .setPositiveButton(getLocalizedString(R.string.instabug_alert_dialog_yes), (dialog, which) -> {
                        dialog.dismiss();
                        currentActivity.onBackPressed();
                    }).setNegativeButton(getLocalizedString(R.string.instabug_alert_dialog_no), (dialog, which) -> {
                        dialog.dismiss();
                    }).show();
    }

    @Override
    public void setUserName(String userName) {
        if (nameEditTextLayout != null)
            nameEditTextLayout.setText(userName);
    }

    private void setFieldError(boolean showError,
                               @Nullable TextInputLayout textInputLayout,
                               @Nullable View underlineView,
                               @Nullable String errorString) {
        if (getContext() == null) return;

        if (textInputLayout != null && underlineView != null) {
            if (showError) {
                textInputLayout.setErrorEnabled(true);
                textInputLayout.setError(errorString);
                TextInputLayoutHelper.setUpperHintColor(textInputLayout, ContextCompat.getColor
                        (getContext(), R.color.ib_fr_add_comment_error));
                underlineView.setBackgroundColor(ContextCompat.getColor(getContext(), R.color
                        .ib_fr_add_comment_error));
            } else {
                TextInputLayoutHelper.setUpperHintColor(textInputLayout, SettingsManager.getInstance().getPrimaryColor());
                textInputLayout.setError(null);
                if (textInputLayout.getEditText() != null && textInputLayout.getEditText().isFocused()) {
                    underlineView.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
                } else {
                    underlineView.setBackgroundColor(AttrResolver.getColor(getContext(), R.attr
                            .ib_fr_add_comment_edit_text_underline_color));
                }
                textInputLayout.setErrorEnabled(false);
            }
        }
    }

    @Override
    @Nullable
    public String getFeatureTitle() {
        if (titleEditTextLayout != null && underLineTitle != null) {

            if (titleEditTextLayout.getText() != null &&
                    !titleEditTextLayout.getText().toString().trim().isEmpty()) {
                setFieldError(false, titleInputLayout, underLineTitle, null);
                return titleEditTextLayout.getText().toString();
            } else {
                setFieldError(true, titleInputLayout, underLineTitle, getLocalizedString(R.string
                        .feature_requests_new_err_msg_required));
                titleEditTextLayout.requestFocus();
                return null;
            }
        }
        return null;
    }

    @Override
    public String getFeatureDescription() {
        if (descriptionEditTextLayout != null) {
            if (descriptionEditTextLayout.getText() == null) {
                return "";
            } else {
                return descriptionEditTextLayout.getText().toString();
            }
        }
        return "";
    }

    @Override
    @Nullable
    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public String getValidEmail() {
        if (emailEditTextLayout != null && emailInputLayout != null && underLineEmail != null) {
            if (emailEditTextLayout.getText() != null
                    && !emailEditTextLayout.getText().toString().trim().isEmpty()
                    && Patterns.EMAIL_ADDRESS.matcher(emailEditTextLayout.getText().toString())
                    .matches()) {
                emailEditTextLayout.setError(null);
                setFieldError(false, emailInputLayout, underLineEmail, null);
                return emailEditTextLayout.getText().toString();
            } else {
                setFieldError(true, emailInputLayout, underLineEmail, getLocalizedString(R.string
                        .feature_request_str_add_comment_valid_email));
                emailEditTextLayout.requestFocus();
                return null;
            }
        }
        return null;
    }

    @Override
    public void hideUserEmail() {
        if (emailInputLayout != null)
            emailInputLayout.setVisibility(View.GONE);
        if (emailDisclaimer != null)
            emailDisclaimer.setVisibility(View.GONE);
        if (underLineEmail != null)
            underLineEmail.setVisibility(View.GONE);
    }

    @Override
    public void hideUserName() {
        if (nameInputLayout != null)
            nameInputLayout.setVisibility(View.GONE);
        if (underLineName != null)
            underLineName.setVisibility(View.GONE);
    }

    @Override
    public String getEmailString() {
        if (emailEditTextLayout != null && emailEditTextLayout.getText() != null) {
            return emailEditTextLayout.getText().toString();
        }
        return "";
    }

    @Override
    public String getNameString() {
        if (nameEditTextLayout != null && nameEditTextLayout.getText() != null) {
            return nameEditTextLayout.getText().toString();
        }
        return "";
    }

    @Override
    public void setUserEmail(String userEmail) {
        if (emailEditTextLayout != null) {
            emailEditTextLayout.setText(userEmail);
        }
    }

    @Override
    protected ToolbarActionButton getToolbarCloseActionButton() {
        return new ToolbarActionButton(R.drawable.ibg_core_ic_close, R.string.close,
                new ToolbarActionButton.OnToolbarButtonClick() {
                    @Override
                    public void onClick() {
                        close();
                    }
                }, ICON);
    }

    @Override
    protected void addToolbarActionButtons() {
        toolbarActionButtons.add(new ToolbarActionButton(R.drawable.ibg_fr_shape_add_feat_button,
                R.string.feature_requests_new_positive_button,
                new ToolbarActionButton.OnToolbarButtonClick() {
                    @Override
                    public void onClick() {
                        if (presenter != null) {
                            presenter.onAddButtonClicked();
                        }
                    }
                }, TEXT));
    }

    @Override
    protected String getTitle() {
        return getLocalizedString(R.string.feature_requests_new_appbar_title);
    }

    @Override
    protected int getContentLayout() {
        return R.layout.ib_fr_new_feature_fragment;
    }

    @Override
    protected void initContentViews(View rootView, @Nullable Bundle savedInstanceState) {
        relativeLayoutNewFeature = rootView.findViewById(R.id.relativeLayout_new_feature);

        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.UPSIDE_DOWN_CAKE && relativeLayoutNewFeature != null) {
            ViewUtilsKt.addSystemWindowInsetToPadding(relativeLayoutNewFeature, true, false, true, true);
        }

        titleInputLayout = rootView.findViewById(R.id.input_layout_title);
        if (titleInputLayout != null)
            titleInputLayout.setHint(getLocalizedString(R.string.feature_requests_new_title) + "*");
        descriptionInputLayout = rootView.findViewById(R.id.input_layout_description);
        nameInputLayout = rootView.findViewById(R.id.name_text_input_layout);
        emailInputLayout = rootView.findViewById(R.id.email_text_input_layout);
        if (emailInputLayout != null)
            emailInputLayout.setHint(getLocalizedString(R.string.ib_email_label) + "*");

        titleEditTextLayout = rootView.findViewById(R.id.input_title);
        descriptionEditTextLayout = rootView.findViewById(R.id.input_description);
        nameEditTextLayout = rootView.findViewById(R.id.input_name);
        emailEditTextLayout = rootView.findViewById(R.id.input_email);

        underLineTitle = rootView.findViewById(R.id.title_underline);
        underLineDescription = rootView.findViewById(R.id.description_underline);
        underLineName = rootView.findViewById(R.id.name_underline);
        underLineEmail = rootView.findViewById(R.id.email_underline);

        emailDisclaimer = rootView.findViewById(R.id.txtBottomHint);

        TextInputLayoutHelper.setUpperHintColor(titleInputLayout, SettingsManager.getInstance().getPrimaryColor());
        TextInputLayoutHelper.setUpperHintColor(descriptionInputLayout, SettingsManager.getInstance().getPrimaryColor());
        TextInputLayoutHelper.setUpperHintColor(nameInputLayout, SettingsManager.getInstance().getPrimaryColor());
        TextInputLayoutHelper.setUpperHintColor(emailInputLayout, SettingsManager.getInstance().getPrimaryColor());
        // Use a local allocation to overcome SpotBugs false-positive possible NPE warnings
        AddNewFeaturePresenter localPresenter = new AddNewFeaturePresenter(this);

        handleEditTextFocusChange();

        if (savedInstanceState == null) {
            showCustomToast();
        }

        toolbarAddTextView = (TextView) findTextViewByTitle(R.string.feature_requests_new_positive_button);
        setToolbarAddTextViewEnabled(false);
        localPresenter.handelRequiredFieldsHints();
        presenter = localPresenter;
    }

    private void handleEditTextFocusChange() {
        TextInputEditText localTitleEditTextLayout = titleEditTextLayout;
        TextInputEditText localEmailEditTextLayout = emailEditTextLayout;

        if (localTitleEditTextLayout != null) {
            localTitleEditTextLayout.setOnFocusChangeListener((v, hasFocus) -> {
                if (getContext() == null) return;
                // Use a local allocation to overcome SpotBugs false-positive possible NPE warnings
                View localUnderLineTitle = underLineTitle;
                if (localUnderLineTitle != null && titleInputLayout != null) {
                    if (hasFocus) {
                        localUnderLineTitle.getLayoutParams().height = ViewUtils.convertDpToPx(getContext(),
                                2);
                        if (titleInputLayout.isErrorEnabled()) {
                            TextInputLayoutHelper.setUpperHintColor(titleInputLayout,
                                    ContextCompat.getColor(getContext(), R.color
                                            .ib_fr_add_comment_error));
                            localUnderLineTitle.setBackgroundColor(ContextCompat.getColor(getContext(), R
                                    .color.ib_fr_add_comment_error));
                        } else {
                            TextInputLayoutHelper.setUpperHintColor(titleInputLayout, SettingsManager.getInstance().getPrimaryColor());
                            localUnderLineTitle.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
                        }
                    } else {
                        TextInputLayoutHelper.setUpperHintColor(titleInputLayout, SettingsManager.getInstance().getPrimaryColor());

                        localUnderLineTitle.setBackgroundColor(AttrResolver.getColor(getContext(), R.attr
                                .ib_fr_add_comment_edit_text_underline_color));
                        localUnderLineTitle.getLayoutParams().height = ViewUtils.convertDpToPx(getContext(), 1);
                    }
                    localUnderLineTitle.requestLayout();
                    underLineTitle = localUnderLineTitle;
                }
            });

            localTitleEditTextLayout.addTextChangedListener(new SimpleTextWatcher() {
                @Override
                public void afterTextChanged(Editable s) {
                    super.afterTextChanged(s);
                    // Use a local allocation to overcome SpotBugs false-positive possible NPE warnings
                    if (localTitleEditTextLayout != null) {
                        if (localTitleEditTextLayout.getText() != null
                                && localTitleEditTextLayout.getText().toString().trim().isEmpty()) {
                            setFieldError(true, titleInputLayout, underLineTitle, getLocalizedString(R.string
                                    .feature_requests_new_err_msg_required));
                            setToolbarAddTextViewEnabled(false);
                        } else {
                            setFieldError(false, titleInputLayout, underLineTitle, getLocalizedString(R.string
                                    .feature_requests_new_err_msg_required));
                            if (FeaturesRequestSettings.getInstance().isNewFeatureEmailFieldRequired()
                                    && FeaturesRequestSettings.getInstance().isUserIdentificationStateEnabled()) {
                                if (localEmailEditTextLayout != null)
                                    setToolbarAddTextViewEnabled(localEmailEditTextLayout.getText() != null
                                            && !localEmailEditTextLayout.getText().toString().trim().isEmpty()
                                            && Patterns.EMAIL_ADDRESS.matcher(localEmailEditTextLayout.getText()
                                                    .toString())
                                            .matches());
                            } else {
                                setToolbarAddTextViewEnabled(true);
                            }
                        }
                    }
                    titleEditTextLayout = localTitleEditTextLayout;
                }
            });
        }
        if (descriptionEditTextLayout != null) {
            descriptionEditTextLayout.setOnFocusChangeListener((v, hasFocus) -> {
                if (getContext() == null) return;
                // Use a local allocation to overcome SpotBugs false-positive possible NPE warnings
                View localUnderLineDescription = underLineDescription;
                if (localUnderLineDescription != null) {
                    if (hasFocus) {
                        localUnderLineDescription.getLayoutParams().height = ViewUtils.convertDpToPx
                                (getContext(), 2);
                        if (descriptionInputLayout != null && descriptionInputLayout.isErrorEnabled()) {
                            TextInputLayoutHelper.setUpperHintColor(
                                    titleInputLayout, ContextCompat.getColor(getContext(),
                                            R.color.ib_fr_add_comment_error));
                            localUnderLineDescription.setBackgroundColor(ContextCompat.getColor(getContext
                                    (), R.color.ib_fr_add_comment_error));
                        } else {
                            TextInputLayoutHelper.setUpperHintColor(titleInputLayout, SettingsManager.getInstance().getPrimaryColor());
                            localUnderLineDescription.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
                        }
                    } else {
                        TextInputLayoutHelper.setUpperHintColor(titleInputLayout, SettingsManager.getInstance().getPrimaryColor());
                        localUnderLineDescription.setBackgroundColor(AttrResolver.getColor(getContext(), R
                                .attr.ib_fr_add_comment_edit_text_underline_color));
                        localUnderLineDescription.getLayoutParams().height = ViewUtils.convertDpToPx
                                (getContext(), 1);
                    }
                    localUnderLineDescription.requestLayout();
                    underLineDescription = localUnderLineDescription;
                }
            });
        }

        if (nameEditTextLayout != null) {
            nameEditTextLayout.setOnFocusChangeListener(new View.OnFocusChangeListener() {
                @SuppressLint("STARVATION")
                @Override
                public void onFocusChange(View v, boolean hasFocus) {
                    if (getContext() == null) return;
                    // Use a local allocation to overcome SpotBugs false-positive possible NPE warnings
                    View localUnderLineName = underLineName;
                    if (localUnderLineName != null) {
                        if (hasFocus) {
                            localUnderLineName.getLayoutParams().height = ViewUtils.convertDpToPx(getContext()
                                    , 2);
                            localUnderLineName.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
                        } else {
                            localUnderLineName.getLayoutParams().height = ViewUtils.convertDpToPx(getContext()
                                    , 1);
                            localUnderLineName.setBackgroundColor(AttrResolver.getColor(getContext(), R.attr
                                    .ib_fr_add_comment_edit_text_underline_color));
                        }
                        localUnderLineName.requestLayout();
                        underLineName = localUnderLineName;
                    }
                }
            });
        }

        if (localEmailEditTextLayout != null) {
            localEmailEditTextLayout.setOnFocusChangeListener((v, hasFocus) -> {
                if (getContext() == null) return;
                // Use a local allocation to overcome SpotBugs false-positive possible NPE warnings
                View localUnderLineEmail = underLineEmail;
                if (localUnderLineEmail != null) {
                    if (hasFocus) {
                        localUnderLineEmail.getLayoutParams().height =
                                ViewUtils.convertDpToPx(getContext(), 2);
                        if (emailInputLayout != null && emailInputLayout.isErrorEnabled()) {
                            if (nameInputLayout != null)
                                nameInputLayout.setErrorEnabled(true);
                            TextInputLayoutHelper.setUpperHintColor(emailInputLayout,
                                    ContextCompat.getColor(getContext(), R.color
                                            .ib_fr_add_comment_error));
                            localUnderLineEmail.setBackgroundColor(ContextCompat.getColor(getContext(), R
                                    .color.ib_fr_add_comment_error));
                        } else {
                            if (nameInputLayout != null)
                                nameInputLayout.setErrorEnabled(false);
                            TextInputLayoutHelper.setUpperHintColor(emailInputLayout, SettingsManager.getInstance().getPrimaryColor());
                            localUnderLineEmail.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
                        }
                    } else {
                        TextInputLayoutHelper.setUpperHintColor(emailInputLayout, SettingsManager.getInstance().getPrimaryColor());
                        localUnderLineEmail.setBackgroundColor(AttrResolver.getColor(getContext(), R.attr
                                .ib_fr_add_comment_edit_text_underline_color));
                        localUnderLineEmail.getLayoutParams().height = ViewUtils.convertDpToPx(getContext(), 1);
                    }
                    localUnderLineEmail.requestLayout();
                    underLineEmail = localUnderLineEmail;
                }
            });


            localEmailEditTextLayout.addTextChangedListener(new SimpleTextWatcher() {
                @Override
                public void afterTextChanged(Editable s) {
                    if (presenter == null) return;
                    if (FeaturesRequestSettings.getInstance().isNewFeatureEmailFieldRequired()) {
                        if (!(s.toString().equals(presenter.getEnteredEmail()))) {
                            String validEmail = getValidEmail();
                            if (validEmail != null) {
                                if (localTitleEditTextLayout != null
                                        && localTitleEditTextLayout.getText() != null
                                        && !localTitleEditTextLayout.getText().toString().trim().isEmpty()) {
                                    setToolbarAddTextViewEnabled(true);
                                }
                            } else {
                                setToolbarAddTextViewEnabled(false);
                            }
                        }
                    }
                    if (emailDisclaimer != null) {
                        if (!TextUtils.isEmpty(s.toString())) {
                            emailDisclaimer.setVisibility(View.GONE);
                        } else {
                            emailDisclaimer.setVisibility(View.VISIBLE);
                        }
                    }
                    emailEditTextLayout = localEmailEditTextLayout;
                }

            });
        }

    }

    @Override
    public void setEmailHintStringWithAsterisk(boolean withAsterisk) {
        if (emailInputLayout != null) {
            if (withAsterisk) {
                emailInputLayout.setHint(getLocalizedString(R.string.ib_email_label) + "*");
            } else {
                emailInputLayout.setHint(getLocalizedString(R.string.ib_email_label));
            }
        }
    }

    private void showCustomToast() {
        if (toolbar == null) return;

        toolbar.post(() -> {
            if (getContext() == null) return;

            String toastMessage = PlaceHolderUtils.getPlaceHolder(
                    InstabugCustomTextPlaceHolder.Key
                            .FEATURES_REQUEST_ADD_FEATURE_TOAST,
                    getLocalizedString(R.string.feature_requests_new_toast_message));

            InstaToast snackbar = InstaToast.make(relativeLayoutNewFeature, toastMessage != null ? toastMessage :
                            getLocalizedString(R.string.feature_requests_new_toast_message),
                    InstaToast.LENGTH_LONG);
            snackbar.setActionTextColor(Color.WHITE);
            if (LocaleHelper.isRTL(getContext())) {
                snackbar.setIconLeft(R.drawable.ibg_core_ic_close, 24);
            } else {
                snackbar.setIconRight(R.drawable.ibg_core_ic_close, 24);
            }
            snackbar.setMaxWidth(3000);
            View snackbarView = snackbar.getView();
            snackbarView.setBackgroundColor(getResources().getColor(R.color
                    .ib_fr_new_feature_toast_bg));
            TextView textView = snackbarView.findViewById(R.id.snackbar_text);
            if (textView != null) {
                textView.setTextColor(Color.WHITE);
                snackbar.show();
            }
        });
    }

    @Override
    public void close() {
        if (isThereAnyDataFilledInAnyFieldInTheScreen()) {
            showExitDialog();
        } else {
            if (getActivity() != null) {
                getActivity().onBackPressed();
            }
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        if (getActivity() != null) {
            KeyboardUtils.hide(getActivity());
        }
    }

    private void setToolbarAddTextViewEnabled(Boolean enabled) {
        if (toolbarAddTextView != null) {
            if (enabled) {
                toolbarAddTextView.setEnabled(true);
                toolbarAddTextView.setTextColor(getResources().getColor(android.R.color.white));
            } else {
                toolbarAddTextView.setEnabled(false);
                toolbarAddTextView.setTextColor(getResources().getColor(android.R.color
                        .darker_gray));
            }
        }
    }

    private boolean isThereAnyDataFilledInAnyFieldInTheScreen() {
        if (titleEditTextLayout != null && descriptionEditTextLayout != null && nameEditTextLayout != null && emailEditTextLayout != null) {
            return (titleEditTextLayout.getText() != null && !titleEditTextLayout.getText().toString().isEmpty())
                    || (descriptionEditTextLayout.getText() != null && !descriptionEditTextLayout.getText().toString().isEmpty())
                    || (nameEditTextLayout.getText() != null && !nameEditTextLayout.getText().toString().isEmpty())
                    || (emailEditTextLayout.getText() != null && !emailEditTextLayout.getText().toString().isEmpty());
        }
        return false;
    }
}