package com.instabug.featuresrequest.network;

import androidx.annotation.VisibleForTesting;

import com.instabug.featuresrequest.models.NewComment;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestParameter;

/**
 * Created by mzelzoghbi on 3/11/18.
 */

public class AddCommentUtil {

    @VisibleForTesting
    static final String NAME_PARAM = "name";
    @VisibleForTesting
    static final String EMAIL_PARAM = "email";
    @VisibleForTesting
    static final String BODY_PARAM = "body";
    @VisibleForTesting
    static final String CREATED_AT = "created_at";
    @VisibleForTesting
    static final String PUSH_TOKEN_PARAM = "push_token";

    public static Request.Builder addParamsToAddCommentRequest(Request.Builder requestBuilder, NewComment newComment) {
        requestBuilder.addParameter(new RequestParameter(BODY_PARAM, newComment.getBody()));
        requestBuilder.addParameter(new RequestParameter(CREATED_AT, newComment.getCreatedAt()));
        if (newComment.getCommenterName() != null
                && !newComment.getCommenterName().trim().isEmpty()) {
            requestBuilder.addParameter(new RequestParameter(NAME_PARAM, newComment.getCommenterName()));
        }
        String commenterEmail = newComment.getCommenterEmail();
        if (commenterEmail != null && !commenterEmail.trim().isEmpty())
            requestBuilder.addParameter(new RequestParameter<>(EMAIL_PARAM, commenterEmail));
        requestBuilder.addParameter(new RequestParameter(PUSH_TOKEN_PARAM, InstabugCore.getPushNotificationToken()));
        return requestBuilder;
    }
}
