package com.instabug.featuresrequest.utils;

import android.annotation.SuppressLint;
import android.content.res.ColorStateList;
import android.widget.TextView;

import com.google.android.material.textfield.TextInputLayout;
import com.instabug.featuresrequest.R;
import com.instabug.library.Constants;
import com.instabug.library.Instabug;
import com.instabug.library.util.InstabugSDKLogger;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;

/**
 * Created by mzelzoghbi on 3/8/18.
 */

public class TextInputLayoutHelper {
    public static void setUpperHintColor(@Nullable TextInputLayout textInputLayout, int color) {
        if(textInputLayout != null) {
            try {
                Field field = textInputLayout.getClass().getDeclaredField("mFocusedTextColor");
                field.setAccessible(true);
                int[][] states = new int[][]{
                        new int[]{}
                };
                int[] colors = new int[]{
                        color
                };
                ColorStateList myList = new ColorStateList(states, colors);
                field.set(textInputLayout, myList);

                Method method = textInputLayout.getClass().getDeclaredMethod("updateLabelState", boolean.class);
                method.setAccessible(true);
                method.invoke(textInputLayout, true);


                if (Instabug.getApplicationContext() == null) return;
                setErrorTextColor(textInputLayout, ContextCompat.getColor(Instabug.getApplicationContext(), R.color.ib_fr_add_comment_error));
            } catch (Exception e) {
            }
        }
    }

    public static void setErrorTextColor(TextInputLayout textInputLayout, int color) {
        try {
            Field fErrorView = TextInputLayout.class.getDeclaredField("mErrorView");
            fErrorView.setAccessible(true);
            TextView mErrorView = (TextView) fErrorView.get(textInputLayout);
            @SuppressLint("SoonBlockedPrivateApi") Field fCurTextColor = TextView.class.getDeclaredField("mCurTextColor");
            fCurTextColor.setAccessible(true);
            fCurTextColor.set(mErrorView, color);
        } catch (Exception e) {
            InstabugSDKLogger.e(Constants.LOG_TAG,"Exception happened while set Error Text color" + e);
        }
    }
}
