package com.instabug.featuresrequest.ui.custom;

import android.os.Bundle;
import android.os.Handler;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.utils.FeatureRequestThemeResolver;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.StatusBarUtils;
import com.instabug.library.util.UiUtils;

/**
 * @author mohamedzakaria.
 */


public class ThanksActivity extends AppCompatActivity implements _InstabugActivity {


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
        StatusBarUtils.setStatusBarForDialog(this);

        LocaleUtils.setLocale(this, InstabugCore.getLocale(this));
        super.onCreate(savedInstanceState);

        if (InstabugCore.isFullScreen()) {
            UiUtils.showInFullscreen(getWindow());
        }
        setTheme(FeatureRequestThemeResolver.resolveTheme(InstabugCore.getTheme()));
        setContentView(R.layout.ib_fr_thanks_dialog);
        initViews();
        initDismissHandler();
    }

    private void initViews() {
        TextView thanksMsg = findViewById(R.id.feature_request_add_feature_thanks_msg);
        if (thanksMsg == null) return;

        thanksMsg.setText(PlaceHolderUtils.getPlaceHolder(
                InstabugCustomTextPlaceHolder.Key.FEATURES_REQUEST_ADD_FEATURE_THANKS_MESSAGE,
                LocaleUtils.getLocaleStringResource(Instabug.getLocale(this), R.string.feature_request_str_thanks_msg, this)));

        ImageView thanksImg = findViewById(R.id.instabug_img_thanks);
        if (thanksImg == null) return;

        thanksImg.setColorFilter(SettingsManager.getInstance().getPrimaryColor());
    }

    private void initDismissHandler() {
        new Handler().postDelayed(() -> {
            finish();
            overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
        }, 3000);
    }

}