package com.instabug.featuresrequest.ui.base.featureslist;


import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;

import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.listeners.OnFeatureClickListener;

/**
 * @author hossam.
 */

public class FeatureAdapter extends BaseAdapter {
    private FeaturesListPresenter featuresListPresenter;

    private OnFeatureClickListener onFeatureClickListener;

    FeatureAdapter(FeaturesListPresenter featuresListPresenter,
                   OnFeatureClickListener onFeatureClickListener) {
        this.featuresListPresenter = featuresListPresenter;
        this.onFeatureClickListener = onFeatureClickListener;
    }

    @Override
    public int getCount() {
        return featuresListPresenter.getFeaturesCount();
    }

    @Override
    public Object getItem(int i) {
        return i;
    }

    @Override
    public long getItemId(int i) {
        return i;
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        final FeatureHolder viewHolder;
        if (convertView == null) {

            convertView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.ib_fr_feature_request_item, parent, false);

            viewHolder = new FeatureHolder(convertView, onFeatureClickListener);
            convertView.setTag(viewHolder);
        } else {
            viewHolder = (FeatureHolder) convertView.getTag();
        }

        featuresListPresenter.onBindFeatureViewItemAtPosition(position, viewHolder);

        convertView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onFeatureClickListener.onFeatureClicked(position);
            }
        });
        return convertView;
    }

}
