package com.instabug.featuresrequest;

import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.VoidRunnable;

/**
 * Created by mohamedzakaria on 8/28/17.
 */

public class FeatureRequests {
    /**
     * Shows features requests list
     *
     * @since 8.0.0
     */
    public static void show() {
        APIChecker.checkAndRunInExecutor("FeatureRequests.show", new VoidRunnable() {
            @Override
            public void run() {
                FeatureRequestWrapper.show();
            }
        });
    }

    /**
     * Sets whether email field is required or not when submitting
     * new-feature-request/new-comment-on-feature
     *
     * @param isEmailFieldRequired set true to make email field required
     * @param actions              Bitwise-or of actions
     *                             {@link ActionType#REQUEST_NEW_FEATURE}
     *                             {@link ActionType#ADD_COMMENT_TO_FEATURE}
     * @since 8.0.0
     */
    public static void setEmailFieldRequired(final boolean isEmailFieldRequired, @ActionType final int... actions) {
        APIChecker.checkAndRunInExecutor("FeatureRequests.setEmailFieldRequired", new VoidRunnable() {
            @Override
            public void run() {
                FeatureRequestWrapper.setEmailFieldRequired(isEmailFieldRequired, actions);
            }
        });
    }

    /**
     * Acts as a master switch for the Feature Requests.
     * It's enabled by default. When disabled, all the functionalities related to the Feature Requests is disabled.
     *
     * @param state possible states are available, ENABLED and DISABLED.
     * @see Instabug.Builder#build()
     */
    public static void setState(final Feature.State state) {
        APIChecker.checkAndRunInExecutor("FeatureRequests.setState", new VoidRunnable() {
            @Override
            public void run() {
                FeatureRequestWrapper.setState(state);
            }
        });
    }

    /**
     * Updates the global state that determines whether user identification data should be included in Feature Requests.
     *
     * @param state The state for user identification within Feature Requests.
     *              Use Feature.State.ENABLED to include user data or Feature.State.DISABLED to exclude it.
     */
    public static void setUserIdentificationState(final Feature.State state) {
        APIChecker
                .checkAndRunInExecutor("FeatureRequests.setUserIdentificationState",
                        () -> FeatureRequestWrapper.setUserIdentificationState(state));
    }

}
