/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.crash.a.a;
import com.instabug.crash.b.a;
import com.instabug.crash.c.b;
import com.instabug.crash.network.InstabugCrashesUploaderService;
import com.instabug.library.APIBuildChecker;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.WriteStateToFileDiskOperation;
import com.instabug.library.internal.video.ScreenRecordingService;
import com.instabug.library.model.Report;
import com.instabug.library.model.State;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ReportHelper;
import com.instabug.library.util.threading.PoolProvider;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashReporting {
    public static void reportException(Throwable throwable) {
        APIBuildChecker.check();
        if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
            return;
        }
        CrashReporting.createFormattedException(throwable, null);
    }

    public static void createFormattedException(Throwable throwable, String identifier) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("error", (Object)com.instabug.crash.e.b.a(throwable, identifier));
            CrashReporting.reportException(jSONObject, true);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private static void reportException(final JSONObject jsonObject, final boolean isHandled) {
        if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
            return;
        }
        if (b.a().isEnabled() && SettingsManager.getInstance().autoScreenRecordingEnabled()) {
            CrashReporting.stopAutoScreenRecording();
        }
        if (SettingsManager.getInstance().getPreReportRunnable() != null) {
            try {
                SettingsManager.getInstance().getPreReportRunnable().run();
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(CrashReporting.class, (String)"Pre sending runnable failed to run.", (Throwable)exception);
            }
        }
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                Context context = Instabug.getApplicationContext();
                State state = State.getState((Context)context);
                SettingsManager settingsManager = SettingsManager.getInstance();
                Report report = CrashReporting.getReport(settingsManager);
                com.instabug.crash.b.a a2 = CrashReporting.getCrash(jsonObject, isHandled, context, state);
                ReportHelper.update((State)a2.e(), (Report)report);
                if (InstabugCore.getExtraAttachmentFiles().size() >= 1) {
                    CrashReporting.addCrashAttachments(context, a2);
                }
                if (b.a().isEnabled() && SettingsManager.getInstance().autoScreenRecordingEnabled()) {
                    CrashReporting.stopAutoScreenRecording();
                }
                if (context != null) {
                    File file = DiskUtils.createStateTextFile((Context)context);
                    CrashReporting.createStateTextFile(context, a2, file);
                }
                CrashReporting.attachASRVideoToCrash(a2);
                a.a(a2);
                InstabugSDKLogger.i(CrashReporting.class, (String)"ReportCaughtException: Your exception has been reported");
                InstabugCrashesUploaderService.a(context, new Intent(context, InstabugCrashesUploaderService.class));
                b.a().b();
            }
        });
    }

    private static void createStateTextFile(Context context, com.instabug.crash.b.a crash, File file) {
        try {
            Uri uri = DiskUtils.with((Context)context).writeOperation((DiskOperation)new WriteStateToFileDiskOperation(file, crash.e().toJson())).execute();
            crash.e().setUri(uri);
            AttachmentsUtility.encryptAttachments(crash.d());
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e(CrashReporting.class, (String)jSONException.toString());
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(CrashReporting.class, (String)iOException.toString());
        }
    }

    public static void stopAutoScreenRecording() {
        AutoScreenRecordingEventBus.getInstance().post((Object)ScreenRecordingService.Action.STOP_KEEP);
    }

    public static void attachASRVideoToCrash(com.instabug.crash.b.a crash) {
        com.instabug.crash.c.a.a(crash);
    }

    public static void addCrashAttachments(Context context, com.instabug.crash.b.a crash) {
        for (Map.Entry entry : InstabugCore.getExtraAttachmentFiles().entrySet()) {
            Uri uri = AttachmentsUtility.getNewFileAttachmentUri((Context)context, (Uri)((Uri)entry.getKey()), (String)((String)entry.getValue()));
            crash.a(uri);
        }
    }

    @NonNull
    public static com.instabug.crash.b.a getCrash(JSONObject jsonObject, boolean handled, Context context, State state) {
        com.instabug.crash.b.a a2 = new a.b().a(context, state);
        a2.c(jsonObject.toString());
        a2.a(a.a.READY_TO_BE_SENT);
        a2.a(handled);
        return a2;
    }

    @NonNull
    public static Report getReport(SettingsManager settingsManager) {
        Report report = new Report();
        if (settingsManager.getOnReportCreatedListener() != null) {
            settingsManager.getOnReportCreatedListener().onReportCreated(report);
        }
        return report;
    }

    public static void reportException(Throwable throwable, @Nullable String exceptionIdentifier) {
        APIBuildChecker.check();
        if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
            return;
        }
        CrashReporting.createFormattedException(throwable, exceptionIdentifier);
    }

    private static void reportUncaughtException(JSONObject jsonObject) {
        CrashReporting.reportException(jsonObject, false);
    }
}

