/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.instabug.crash.a.a;
import com.instabug.crash.a.b;
import com.instabug.crash.cache.CrashesCacheManager;
import com.instabug.crash.models.Crash;
import com.instabug.crash.network.InstabugCrashesUploaderService;
import com.instabug.library.Feature;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.video.AutoScreenRecordingService;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class InstabugCrash {
    public static void reportCaughtException(Context context, Throwable throwable, @Nullable String string) {
        if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("error", (Object)com.instabug.crash.c.a.a(throwable, string));
            if (com.instabug.crash.b.a.a().b() != null) {
                try {
                    com.instabug.crash.b.a.a().b().run();
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(InstabugCrash.class, (String)"Pre sending runnable failed to run.", (Throwable)exception);
                }
            }
            Crash crash = new Crash.a().a(context);
            crash.c(jSONObject.toString());
            crash.a(Crash.CrashState.READY_TO_BE_SENT);
            crash.a(true);
            if (InstabugCore.getExtraAttachmentFiles().size() >= 1) {
                for (Map.Entry entry : InstabugCore.getExtraAttachmentFiles().entrySet()) {
                    Uri uri = AttachmentsUtility.getNewFileAttachmentUri((Context)context, (Uri)((Uri)entry.getKey()), (String)((String)entry.getValue()));
                    crash.a(uri);
                }
            }
            if (b.a().isEnabled()) {
                AutoScreenRecordingEventBus.getInstance().post((Object)AutoScreenRecordingService.Action.STOP_KEEP);
                a.a(crash);
            }
            CrashesCacheManager.addCrash(crash);
            InstabugSDKLogger.i(InstabugCrash.class, (String)"ReportCaughtException: Your exception has been reported");
            context.startService(new Intent(context, InstabugCrashesUploaderService.class));
            b.a().b();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public static void setPreSendingRunnable(Runnable runnable) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("runnable").setType(Runnable.class)});
        com.instabug.crash.b.a.a().a(runnable);
    }
}

