package com.instabug.fatalhangs.model

import androidx.annotation.IntDef

@kotlin.annotation.Retention(AnnotationRetention.SOURCE)
@IntDef(
        FatalHangState.READY_TO_BE_SENT,
        FatalHangState.LOGS_READY_TO_BE_UPLOADED,
        FatalHangState.ATTACHMENTS_READY_TO_BE_UPLOADED
)
annotation class FatalHangState {
    companion object {
        const val READY_TO_BE_SENT = 1
        const val LOGS_READY_TO_BE_UPLOADED = 2
        const val ATTACHMENTS_READY_TO_BE_UPLOADED = 3
    }
}